/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Implementors of this interface must be able to convert an arbitrary
 * String (which may or may not contain XML content) into an object of their
 * choosing that implements IXMLWritable (for the transformation of
 * objects to XML).
 * 
 * 
 * @author David Whiteman
 */
public interface IRecordSerializer {
	public IXMLWritable deserialize(String s);
}
