/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFeatureSelectImpl
extends SPIDataObject
implements MultiFeatureSelect {
    private static final String MULTI_SELECT_TYPE = "sdd-dd:MultiSelectType";

    public MultiFeatureSelectImpl(Element data, SPISessionImpl session) {
        super(data, session, MULTI_SELECT_TYPE);
    }

    @Override
    public Collection<String> getFeatures() {
        ArrayList<String> features = new ArrayList<String>();
        Collection<Element> featureElements = this.getChildren("Feature");
        for (Element featureElement : featureElements) {
            features.add(featureElement.getAttribute("featureRef"));
        }
        return features;
    }

    @Override
    public BigInteger getMaxSelections() {
        BigInteger maxSelections = null;
        if (this.isSetAttribute("maxSelections")) {
            maxSelections = new BigInteger(this.getAttribute("maxSelections"));
        }
        return maxSelections;
    }

    @Override
    public BigInteger getMinSelections() {
        BigInteger minSelections = null;
        if (this.isSetAttribute("minSelections")) {
            minSelections = new BigInteger(this.getAttribute("minSelections"));
        }
        return minSelections;
    }

    @Override
    public void setFeatures(Collection<String> featureRefs) {
        this.session.testCollectionParameter(featureRefs, 1, 2, -1);
        if (featureRefs == null) {
            this.unSetElement("Feature");
        } else {
            ArrayList<Element> featureElements = new ArrayList<Element>();
            this.removeContent(this.getChildren("Feature", false));
            for (String featureRef : featureRefs) {
                Element featureElement = this.session.createDeploymentElement("Feature");
                featureElement.setAttribute("featureRef", featureRef);
                featureElements.add(featureElement);
            }
            this.addContent(featureElements);
        }
    }

    @Override
    public void setMaxSelections(BigInteger maxSelections) {
        if (maxSelections == null) {
            this.unSetAttribute("maxSelections");
        } else {
            this.setAttribute("maxSelections", maxSelections.toString());
        }
    }

    @Override
    public void setMinSelections(BigInteger minSelections) {
        if (minSelections == null) {
            this.unSetAttribute("minSelections");
        } else {
            this.setAttribute("minSelections", minSelections.toString());
        }
    }

    @Override
    public Object clone() {
        return new MultiFeatureSelectImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

