/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.w3c.dom.Element;

public class ResourceMap_Test extends TestCase {
    ResourceMap map;
    ResourceMap clonedMap;
    Element element;

    public ResourceMap_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        
        map = SPISession.DEFAULT_INSTANCE.createBaseFactory().createRequiredResourceMap("resourceRef");
        map.setForeignID("foreignID");
        
        clonedMap = (ResourceMap)map.clone();
        element = ((SPIDataObject)map).getElement();
    }

    public void testGetForeignID() {
        assertEquals("foreignID", map.getForeignID());
        assertEquals("foreignID", clonedMap.getForeignID());
        assertEquals("foreignID", element.getAttribute("foreignId"));
    }

    public void testGetResourceReference() {
        assertEquals("resourceRef", map.getResourceReference());
        assertEquals("resourceRef", clonedMap.getResourceReference());
        assertEquals("resourceRef", element.getAttribute("resourceRef"));
    }

    public void testSetForeignID() {
        map.setForeignID("differentID");
        
        assertEquals("differentID", map.getForeignID());
        assertEquals("differentID", element.getAttribute("foreignId"));
    }

    public void testSetResourceReference() {
        map.setResourceReference("differentRef");
        
        assertEquals("differentRef", map.getResourceReference());
        assertEquals("differentRef", element.getAttribute("resourceRef"));
        
        try {
            map.setResourceReference(null);
            
            fail("ResourceRef was set to null");
        }
        catch (Exception e) {
        }
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject) map).getTranslatableStrings();
        
        assertEquals(0, props.keySet().size());
    }
}