/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;

public class DerivedVariableType
{	
	static Collection<DerivedVariable> merge(Collection<DerivedVariable> derivedVariables1, Collection<DerivedVariable> derivedVariables2)
	{
		// set to hold all the merged variables
		Collection <DerivedVariable> derivedVariablesToRemove = new ArrayList <DerivedVariable> ();
		Iterator <DerivedVariable> derivedVariableIter1 = derivedVariables1.iterator();		
		//iterate through the derivedVariables
		while (derivedVariableIter1.hasNext())
		{
			DerivedVariable derivedVariable1 = (DerivedVariable) derivedVariableIter1.next();
			Iterator <DerivedVariable> derivedVariableIter2 = derivedVariables2.iterator();
			while (derivedVariableIter2.hasNext())
			{
				DerivedVariable derivedVariable2 = (DerivedVariable) derivedVariableIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (derivedVariablesToRemove.contains(derivedVariable2)==false)
				{
					if (equals(derivedVariable1, derivedVariable2))
					{  //merge hosted derivedVariables, types and description groups
						derivedVariablesToRemove.add(derivedVariable2);						
						derivedVariable1 = merge(derivedVariable1,derivedVariable2);						
					}
				}
					
			}
		}
		
		derivedVariables2.removeAll(derivedVariablesToRemove);
		//remove all of the matches that were found
		
		Collection <DerivedVariable> finalDerivedVariables = new ArrayList <DerivedVariable> ();
		//create and return a new collection with all of the remaining items
		finalDerivedVariables.addAll(derivedVariables1);
		finalDerivedVariables.addAll(derivedVariables2);		
		
		return finalDerivedVariables;
	}

	static boolean equals(DerivedVariable b1, DerivedVariable b2)
	{
		boolean equals = true;
		
		// BaseVariable attributes are handled in BaseVariable.equals()
		equals = equals && VariableExpressionType.equals(b1.getExpression(), b2.getExpression());
						
		return equals;
	}	
	
	static DerivedVariable merge (DerivedVariable derivedVariable1, DerivedVariable derivedVariable2)
	{
		//TODO ConditionalExpressions not represented in SPI for this
		return derivedVariable1;		
	}
}