/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;



public class MaintenanceInformationType {
	
	public static MaintenanceInformation merge(MaintenanceInformation info1, MaintenanceInformation info2)
	{
		/*<MaintenanceInformationType> 	 	 	 	
		Severity 		<DisplayTextType> 	Merge
		Category 		<DisplayTextType> 	Merge
		Fix 		<FixIdentityType> 	Yes
		Supersedes 		<MaintenanceInformationType> 	Merge
		any 		namespace="##other" 	 ?*/
		
		if (equals(info1,info2))
		{
			info1.setSeverity(TranslatableStringType.merge(info1.getSeverity(),info2.getSeverity()));
			Collection <TranslatableString> myCategories = info1.getCategory();
			myCategories.addAll(info2.getCategory());
			info1.setCategory(myCategories);
			Collection <MaintenanceInformation> mySupersedes = info1.getSupersedes();
			mySupersedes.addAll(info2.getSupersedes());
			info1.setSupersedes(mySupersedes);
			return info1;
			
		}
		else return null;
	
	}
	
	public static boolean equals(MaintenanceInformation info1, MaintenanceInformation info2)
	{
		Iterator <FixIdentity> fixIter1 = info1.getFixIdentityDefinitions().iterator();
		
		
		if (info1.getFixIdentityDefinitions().size()!=info2.getFixIdentityDefinitions().size())
			return false;
		
		while (fixIter1.hasNext())
		{
			FixIdentity fix1 = fixIter1.next();
			boolean hasequals = false;
			Iterator <FixIdentity> fixIter2 = info2.getFixIdentityDefinitions().iterator();
			while (fixIter2.hasNext())
			{
				FixIdentity fix2 = fixIter2.next();
				if (FixIdentityType.equals(fix1, fix2))
					hasequals = true;
			}
			if (!hasequals)
				return false;
		}
		
		return true;
	}
	
}
