/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg;

import java.util.Collection;
import java.util.Properties;

import org.w3c.dom.Document;

/**
 * Interface base class for the SDD BTG System.
 * <p>
 * The SDD BTG RCP plug-in provides an extension point (<code>"org.eclipse.cosmos.me.deployment.sdd.tooling.btg.dataAggregators"</code>)
 * for plugging in to BTG. The data aggregator plug-ins implement this interface.
 * </p>
 * 
 * 
 */

public interface IBTGDataAggregator {


	/**
	 * 
	 */
	public Collection<Document> aggregateSDDData(Collection<SDDFragment> fragments,
			Properties properties, boolean allowIncompleteSDDs);
	
	/**
	 * 
	 */
	public Collection<BTGProperty> getSupportedProperties();	
}
