/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.logging.events.cbe.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.core.LoggingCoreUtilities;
import org.eclipse.tptp.logging.events.cbe.AssociatedEvent;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.eclipse.tptp.logging.events.cbe.CompletionException;
import org.eclipse.tptp.logging.events.cbe.ComponentIdentification;
import org.eclipse.tptp.logging.events.cbe.ContentHandler;
import org.eclipse.tptp.logging.events.cbe.ContextDataElement;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.ExtendedDataElement;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.MsgCatalogToken;
import org.eclipse.tptp.logging.events.cbe.MsgDataElement;
import org.eclipse.tptp.logging.events.cbe.Situation;
import org.eclipse.tptp.logging.events.cbe.ValidationException;
import org.eclipse.tptp.logging.events.cbe.impl.AssociatedEventImpl;
import org.eclipse.tptp.logging.events.cbe.impl.ComponentIdentificationImpl;
import org.eclipse.tptp.logging.events.cbe.impl.ContextDataElementImpl;
import org.eclipse.tptp.logging.events.cbe.impl.ExtendedDataElementImpl;
import org.eclipse.tptp.logging.events.cbe.impl.MsgDataElementImpl;
import org.eclipse.tptp.logging.events.cbe.impl.SituationImpl;
import org.eclipse.tptp.logging.events.cbe.impl.TemplateContentHandlerImpl;
import org.eclipse.tptp.logging.events.cbe.util.EventFormatter;
import org.eclipse.tptp.logging.events.cbe.util.EventHelpers;

public class CommonBaseEventImpl
implements CommonBaseEvent {
    private static final long serialVersionUID = -7210409289362234835L;
    private transient ContentHandler contentHandler = null;
    private transient boolean isComplete = false;
    protected String creationTime = null;
    protected boolean creationTimeESet = false;
    protected String globalInstanceId = null;
    protected long elapsedTime = 0L;
    protected boolean elapsedTimeESet = false;
    protected String extensionName = null;
    protected String localInstanceId = null;
    protected String msg = null;
    protected short priority = 0;
    protected boolean priorityESet = false;
    protected short repeatCount = 0;
    protected boolean repeatCountESet = false;
    protected long sequenceNumber = 0L;
    protected boolean sequenceNumberESet = false;
    protected short severity = 0;
    protected boolean severityESet = false;
    protected String version = "1.0.1";
    protected List any = null;
    protected Situation situation = null;
    protected List associatedEvents = null;
    protected List contextDataElements = null;
    protected List extendedDataElements = null;
    protected MsgDataElement msgDataElement = null;
    protected ComponentIdentification reporterComponentId = null;
    protected ComponentIdentification sourceComponentId = null;

    protected CommonBaseEventImpl() {
    }

    public List getAny() {
        if (this.any == null) {
            this.any = new ArrayList();
        }
        return this.any;
    }

    public List getAssociatedEvents() {
        if (this.associatedEvents == null) {
            this.associatedEvents = new ArrayList();
        }
        return this.associatedEvents;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.isComplete = false;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public List getContextDataElements() {
        if (this.contextDataElements == null) {
            this.contextDataElements = new ArrayList();
        }
        return this.contextDataElements;
    }

    public List getContextDataElements(String name) {
        ListIterator it = this.getContextDataElements().listIterator();
        ArrayList<ContextDataElement> res = new ArrayList<ContextDataElement>();
        ContextDataElement cde = null;
        while (it.hasNext()) {
            cde = (ContextDataElement)it.next();
            if (cde == null || !cde.getName().equals(name)) continue;
            res.add(cde);
        }
        return res;
    }

    public void setCreationTime(String newCreationTime) {
        this.creationTime = newCreationTime;
        this.creationTimeESet = true;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTimeAsLong(long inDateTime) {
        this.setCreationTime(LoggingCoreUtilities.convertMillisecondsToXsdDateTime((long)inDateTime));
    }

    public long getCreationTimeAsLong() {
        long result = 0L;
        if (this.isSetCreationTime()) {
            try {
                result = LoggingCoreUtilities.convertXsdDateTimeToMilliseconds((String)this.getCreationTime());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(String.valueOf(this.getCreationTime()) + " is not a valid xsd:dateTime string");
            }
        }
        return result;
    }

    public void setElapsedTime(long newElapsedTime) {
        this.elapsedTime = newElapsedTime;
        this.elapsedTimeESet = true;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public List getExtendedDataElements() {
        if (this.extendedDataElements == null) {
            this.extendedDataElements = new ArrayList();
        }
        return this.extendedDataElements;
    }

    public List getExtendedDataElements(String name) {
        ListIterator it = this.getExtendedDataElements().listIterator();
        ArrayList<ExtendedDataElement> res = new ArrayList<ExtendedDataElement>();
        ExtendedDataElement ede = null;
        while (it.hasNext()) {
            ede = (ExtendedDataElement)it.next();
            if (ede == null || !ede.getName().equals(name)) continue;
            res.add(ede);
        }
        return res;
    }

    public void setExtensionName(String newExtensionName) {
        this.extensionName = newExtensionName;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setGlobalInstanceId(String newGlobalInstanceId) {
        this.globalInstanceId = newGlobalInstanceId;
    }

    public String getGlobalInstanceId() {
        return this.globalInstanceId;
    }

    public void setLocalInstanceId(String newLocalInstanceId) {
        this.localInstanceId = newLocalInstanceId;
    }

    public String getLocalInstanceId() {
        return this.localInstanceId;
    }

    public void setMsg(String newMsg) {
        this.msg = newMsg;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsgDataElement(MsgDataElement newMsgDataElement) {
        this.msgDataElement = newMsgDataElement;
    }

    public MsgDataElement setMsgDataElement(String msgCatalog, String msgCatalogId, MsgCatalogToken[] tokens, String msgCatalogType, String msgId, String msgIdType, String msgCatalogLocale) {
        MsgDataElement mde = EventFactory.eINSTANCE.createMsgDataElement();
        mde.setMsgCatalog(msgCatalog);
        mde.setMsgCatalogId(msgCatalogId);
        mde.setMsgCatalogTokens(tokens);
        mde.setMsgCatalogType(msgCatalogType);
        mde.setMsgId(msgId);
        mde.setMsgIdType(msgIdType);
        mde.setMsgLocale(msgCatalogLocale);
        this.setMsgDataElement(mde);
        return mde;
    }

    public MsgDataElement setMsgDataElement(String msgCatalog, String msgCatalogId, String[] tokens, String msgCatalogType, String msgId, String msgIdType, String msgCatalogLocale) {
        MsgDataElement mde = EventFactory.eINSTANCE.createMsgDataElement();
        mde.setMsgCatalog(msgCatalog);
        mde.setMsgCatalogId(msgCatalogId);
        mde.setMsgCatalogTokensAsStrings(tokens);
        mde.setMsgCatalogType(msgCatalogType);
        mde.setMsgId(msgId);
        mde.setMsgIdType(msgIdType);
        mde.setMsgLocale(msgCatalogLocale);
        this.setMsgDataElement(mde);
        return mde;
    }

    public MsgDataElement getMsgDataElement() {
        return this.msgDataElement;
    }

    public void setPriority(short newPriority) {
        this.priority = newPriority;
        this.priorityESet = true;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setRepeatCount(short newRepeatCount) {
        this.repeatCount = newRepeatCount;
        this.repeatCountESet = true;
    }

    public short getRepeatCount() {
        return this.repeatCount;
    }

    public void setReporterComponentId(ComponentIdentification newReporterComponentId) {
        this.reporterComponentId = newReporterComponentId;
    }

    public void setReporterComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String executionEnvironment, String instanceId, String location, String locationType, String processId, String threadId) {
        ComponentIdentification cid = EventFactory.eINSTANCE.createComponentIdentification();
        cid.setApplication(application);
        cid.setComponent(component);
        cid.setComponentType(componentType);
        cid.setComponentIdType(componentIdType);
        cid.setExecutionEnvironment(executionEnvironment);
        cid.setInstanceId(instanceId);
        cid.setLocation(location);
        cid.setLocationType(locationType);
        cid.setProcessId(processId);
        cid.setApplication(application);
        cid.setSubComponent(subComponent);
        cid.setThreadId(threadId);
        this.setReporterComponentId(cid);
    }

    public void setReporterComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String location, String locationType) {
        this.setReporterComponentId(application, component, subComponent, componentType, componentIdType, null, null, location, locationType, null, null);
    }

    public ComponentIdentification getReporterComponentId() {
        return this.reporterComponentId;
    }

    public void setSequenceNumber(long newSequenceNumber) {
        this.sequenceNumber = newSequenceNumber;
        this.sequenceNumberESet = true;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isSetCreationTime() {
        return this.creationTimeESet;
    }

    public boolean isSetElapsedTime() {
        return this.elapsedTimeESet;
    }

    public boolean isSetPriority() {
        return this.priorityESet;
    }

    public boolean isSetRepeatCount() {
        return this.repeatCountESet;
    }

    public boolean isSetSequenceNumber() {
        return this.sequenceNumberESet;
    }

    public boolean isSetSeverity() {
        return this.severityESet;
    }

    public void setSeverity(short newSeverity) {
        this.severity = newSeverity;
        this.severityESet = true;
    }

    public short getSeverity() {
        return this.severity;
    }

    public void setSituation(Situation newSituation) {
        this.situation = newSituation;
    }

    public Situation getSituation() {
        return this.situation;
    }

    public void setSourceComponentId(ComponentIdentification newSourceComponentId) {
        this.sourceComponentId = newSourceComponentId;
    }

    public void setSourceComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String executionEnvironment, String instanceId, String location, String locationType, String processId, String threadId) {
        ComponentIdentification cid = EventFactory.eINSTANCE.createComponentIdentification();
        cid.setApplication(application);
        cid.setComponent(component);
        cid.setSubComponent(subComponent);
        cid.setComponentType(componentType);
        cid.setComponentIdType(componentIdType);
        cid.setExecutionEnvironment(executionEnvironment);
        cid.setInstanceId(instanceId);
        cid.setLocation(location);
        cid.setLocationType(locationType);
        cid.setProcessId(processId);
        cid.setThreadId(threadId);
        this.setSourceComponentId(cid);
    }

    public void setSourceComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String location, String locationType) {
        this.setSourceComponentId(application, component, subComponent, componentType, componentIdType, null, null, location, locationType, null, null);
    }

    public ComponentIdentification getSourceComponentId() {
        return this.sourceComponentId;
    }

    public void setVersion(String newVersion) {
        this.version = newVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void addAny(String any) {
        this.getAny().add(any);
    }

    public void clearAny() {
        this.getAny().clear();
    }

    public AssociatedEvent addAssociatedEvent(String associationEngineName, String associationEngineType, String associationEngineId, String[] resolvedEvents) {
        AssociatedEvent ase = EventFactory.eINSTANCE.createAssociatedEvent();
        ase.setAssociationEngineInfo(associationEngineName, associationEngineType, associationEngineId);
        ase.setResolvedEventsAsArray(resolvedEvents);
        this.getAssociatedEvents().add(ase);
        return ase;
    }

    private ContextDataElement addContextDataElement(String contextType, String contextName, String contextValue, String contextId) {
        ContextDataElement cde = EventFactory.eINSTANCE.createContextDataElement();
        if (contextId != null) {
            cde.setContextId(contextId);
        }
        if (contextValue != null) {
            cde.setContextValue(contextValue);
        }
        cde.setName(contextName);
        cde.setType(contextType);
        this.getContextDataElements().add(cde);
        return cde;
    }

    public ContextDataElement addContextDataElementWithValue(String contextType, String contextName, String contextValue) {
        return this.addContextDataElement(contextType, contextName, contextValue, null);
    }

    public ContextDataElement addContextDataElementWithId(String contextType, String contextName, String contextId) {
        return this.addContextDataElement(contextType, contextName, null, contextId);
    }

    public ExtendedDataElement addExtendedDataElement(String name, int type, String value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setTypeAsInt(type);
        if (19 == type) {
            ede.setHexValue(value);
        } else {
            ede.getValues().add(value);
        }
        return ede;
    }

    public ExtendedDataElement addExtendedDataElement(String name, int type, String[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setTypeAsInt(type);
        ede.getValues().addAll(Arrays.asList(values));
        return ede;
    }

    public ExtendedDataElement addExtendedDataElement(String name, String value) {
        return this.addExtendedDataElement(name, 7, value);
    }

    public ExtendedDataElement addExtendedDataElement(String name, String[] values) {
        return this.addExtendedDataElement(name, 16, values);
    }

    public ExtendedDataElement addExtendedDataElement(ExtendedDataElement extendedDataElement) {
        this.getExtendedDataElements().add(extendedDataElement);
        return extendedDataElement;
    }

    public ExtendedDataElement addExtendedDataElement(String name) {
        ExtendedDataElement ede = EventFactory.eINSTANCE.createExtendedDataElement();
        ede.setName(name);
        this.getExtendedDataElements().add(ede);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithByteArrayValue(String name, byte[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsByteArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithByteValue(String name, byte value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsByte(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithNoValue(String name) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setType("noValue");
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithBooleanArrayValue(String name, boolean[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsBooleanArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithBooleanValue(String name, boolean value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsBoolean(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDateArrayValue(String name, String[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDateArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDateAsLongValue(String name, long value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDateAsLong(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDateValue(String name, String value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDate(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDatesAsLongValue(String name, long[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDateAsLongArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDoubleArrayValue(String name, double[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDoubleArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithDoubleValue(String name, double value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsDouble(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithFloatArrayValue(String name, float[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsFloatArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithFloatValue(String name, float value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsFloat(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithIntArrayValue(String name, int[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsIntArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithIntValue(String name, int value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsInt(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithLongArrayValue(String name, long[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsLongArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithLongValue(String name, long value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsLong(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithShortArrayValue(String name, short[] values) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsShortArray(values);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithShortValue(String name, short value) {
        ExtendedDataElement ede = this.addExtendedDataElement(name);
        ede.setValuesAsShort(value);
        return ede;
    }

    public ExtendedDataElement addExtendedDataElementWithHexValue(String name, byte[] hexValue) {
        ExtendedDataElement result = EventFactory.eINSTANCE.createExtendedDataElement();
        result.setType("hexBinary");
        result.setName(name);
        result.setHexValueAsByteArray(hexValue);
        this.getExtendedDataElements().add(result);
        return result;
    }

    public ExtendedDataElement addExtendedDataElementWithHexValue(String name, String hexValue) {
        ExtendedDataElement result = EventFactory.eINSTANCE.createExtendedDataElement();
        result.setType("hexBinary");
        result.setName(name);
        result.setHexValue(hexValue);
        this.getExtendedDataElements().add(result);
        return result;
    }

    public void clearExtendedDataElements() {
        this.getExtendedDataElements().clear();
    }

    public void removeExtendedDataElements(String name) {
        if (this.getExtendedDataElements() != null) {
            int counter = 0;
            while (counter < this.getExtendedDataElements().size()) {
                if (((ExtendedDataElement)this.extendedDataElements.get(counter)).getName().equals(name)) {
                    this.extendedDataElements.remove(counter--);
                }
                ++counter;
            }
        }
    }

    public ContextDataElement addContextDataElement(ContextDataElement contextDataElement) {
        this.getContextDataElements().add(contextDataElement);
        return contextDataElement;
    }

    public void clearContextDataElements() {
        this.getContextDataElements().clear();
    }

    public void removeContextDataElements(String name) {
        if (this.getContextDataElements() != null) {
            int counter = 0;
            while (counter < this.getContextDataElements().size()) {
                if (((ContextDataElement)this.getContextDataElements().get(counter)).getName().equals(name)) {
                    this.getContextDataElements().remove(counter--);
                }
                ++counter;
            }
        }
    }

    public AssociatedEvent addAssociatedEvent(AssociatedEvent associatedEvent) {
        this.getAssociatedEvents().add(associatedEvent);
        return associatedEvent;
    }

    public void clearAssociatedEvents() {
        this.getAssociatedEvents().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() throws CompletionException {
        if (this.contentHandler != null) {
            CommonBaseEventImpl commonBaseEventImpl = this;
            synchronized (commonBaseEventImpl) {
                this.contentHandler.completeEvent(this);
            }
            this.isComplete = true;
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        CommonBaseEventImpl commonBaseEventImpl = this;
        synchronized (commonBaseEventImpl) {
            block19: {
                if (this != object) break block19;
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                Object thisObjectsProperty = this.getGlobalInstanceId();
                Object parameterObjectsProperty = ((CommonBaseEventImpl)object).getGlobalInstanceId();
                if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                    thisObjectsProperty = this.getCreationTime();
                    parameterObjectsProperty = ((CommonBaseEventImpl)object).getCreationTime();
                    if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                        thisObjectsProperty = this.getLocalInstanceId();
                        parameterObjectsProperty = ((CommonBaseEventImpl)object).getLocalInstanceId();
                        if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                            thisObjectsProperty = this.getVersion();
                            parameterObjectsProperty = ((CommonBaseEventImpl)object).getVersion();
                            if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                                thisObjectsProperty = this.getExtensionName();
                                parameterObjectsProperty = ((CommonBaseEventImpl)object).getExtensionName();
                                if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                                    thisObjectsProperty = this.getSituation();
                                    parameterObjectsProperty = ((CommonBaseEventImpl)object).getSituation();
                                    if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                                        thisObjectsProperty = this.getMsg();
                                        parameterObjectsProperty = ((CommonBaseEventImpl)object).getMsg();
                                        if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                                            thisObjectsProperty = this.getMsgDataElement();
                                            parameterObjectsProperty = ((CommonBaseEventImpl)object).getMsgDataElement();
                                            if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                                                thisObjectsProperty = this.getReporterComponentId();
                                                parameterObjectsProperty = ((CommonBaseEventImpl)object).getReporterComponentId();
                                                if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                                                    thisObjectsProperty = this.getSourceComponentId();
                                                    parameterObjectsProperty = ((CommonBaseEventImpl)object).getSourceComponentId();
                                                    if (thisObjectsProperty != null && thisObjectsProperty.equals(parameterObjectsProperty) || thisObjectsProperty == null && parameterObjectsProperty == null) {
                                                        List thisObjectsListProperty = this.getContextDataElements();
                                                        List parameterObjectsListProperty = ((CommonBaseEventImpl)object).getContextDataElements();
                                                        if (thisObjectsListProperty != null && EventHelpers.compareUnorderedLists(thisObjectsListProperty, parameterObjectsListProperty) || (thisObjectsListProperty == null || thisObjectsListProperty.size() == 0) && (parameterObjectsListProperty == null || parameterObjectsListProperty.size() == 0)) {
                                                            thisObjectsListProperty = this.getExtendedDataElements();
                                                            parameterObjectsListProperty = ((CommonBaseEventImpl)object).getExtendedDataElements();
                                                            if (thisObjectsListProperty != null && EventHelpers.compareUnorderedLists(thisObjectsListProperty, parameterObjectsListProperty) || (thisObjectsListProperty == null || thisObjectsListProperty.size() == 0) && (parameterObjectsListProperty == null || parameterObjectsListProperty.size() == 0)) {
                                                                thisObjectsListProperty = this.getAssociatedEvents();
                                                                parameterObjectsListProperty = ((CommonBaseEventImpl)object).getAssociatedEvents();
                                                                if (thisObjectsListProperty != null && EventHelpers.compareUnorderedLists(thisObjectsListProperty, parameterObjectsListProperty) || (thisObjectsListProperty == null || thisObjectsListProperty.size() == 0) && (parameterObjectsListProperty == null || parameterObjectsListProperty.size() == 0)) {
                                                                    thisObjectsListProperty = this.getAny();
                                                                    parameterObjectsListProperty = ((CommonBaseEventImpl)object).getAny();
                                                                    if (thisObjectsListProperty != null && EventHelpers.compareUnorderedLists(thisObjectsListProperty, parameterObjectsListProperty) || (thisObjectsListProperty == null || thisObjectsListProperty.size() == 0) && (parameterObjectsListProperty == null || parameterObjectsListProperty.size() == 0)) {
                                                                        return this.isSetElapsedTime() == ((CommonBaseEventImpl)object).isSetElapsedTime() && this.getElapsedTime() == ((CommonBaseEventImpl)object).getElapsedTime() && this.isSetPriority() == ((CommonBaseEventImpl)object).isSetPriority() && this.getPriority() == ((CommonBaseEventImpl)object).getPriority() && this.isSetRepeatCount() == ((CommonBaseEventImpl)object).isSetRepeatCount() && this.getRepeatCount() == ((CommonBaseEventImpl)object).getRepeatCount() && this.isSetSequenceNumber() == ((CommonBaseEventImpl)object).isSetSequenceNumber() && this.getSequenceNumber() == ((CommonBaseEventImpl)object).getSequenceNumber() && this.isSetSeverity() == ((CommonBaseEventImpl)object).isSetSeverity() && this.getSeverity() == ((CommonBaseEventImpl)object).getSeverity();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return false;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (creationTime: ");
        if (this.creationTimeESet) {
            result.append(this.creationTime);
        } else {
            result.append("<unset>");
        }
        result.append(", globalInstanceId: ");
        result.append(this.globalInstanceId);
        result.append(", elapsedTime: ");
        if (this.elapsedTimeESet) {
            result.append(this.elapsedTime);
        } else {
            result.append("<unset>");
        }
        result.append(", extensionName: ");
        result.append(this.extensionName);
        result.append(", localInstanceId: ");
        result.append(this.localInstanceId);
        result.append(", msg: ");
        result.append(this.msg);
        result.append(", priority: ");
        if (this.priorityESet) {
            result.append(this.priority);
        } else {
            result.append("<unset>");
        }
        result.append(", repeatCount: ");
        if (this.repeatCountESet) {
            result.append(this.repeatCount);
        } else {
            result.append("<unset>");
        }
        result.append(", sequenceNumber: ");
        if (this.sequenceNumberESet) {
            result.append(this.sequenceNumber);
        } else {
            result.append("<unset>");
        }
        result.append(", severity: ");
        if (this.severityESet) {
            result.append(this.severity);
        } else {
            result.append("<unset>");
        }
        result.append(", version: ");
        result.append(this.version);
        result.append(", any: ");
        result.append(this.any);
        result.append(", situation: ");
        result.append(this.situation);
        result.append(", associatedEvents: ");
        result.append(this.associatedEvents);
        result.append(", contextDataElements: ");
        result.append(this.contextDataElements);
        result.append(", extendedDataElements: ");
        result.append(this.extendedDataElements);
        result.append(", msgDataElement: ");
        result.append(this.msgDataElement);
        result.append(", reporterComponentId: ");
        result.append(this.reporterComponentId);
        result.append(", sourceComponentId: ");
        result.append(this.sourceComponentId);
        result.append(')');
        return result.toString();
    }

    public void unsetCreationTime() {
        this.creationTime = null;
        this.creationTimeESet = false;
    }

    public void unsetElapsedTime() {
        this.elapsedTime = 0L;
        this.elapsedTimeESet = false;
    }

    public void unsetPriority() {
        this.priority = 0;
        this.priorityESet = false;
    }

    public void unsetRepeatCount() {
        this.repeatCount = 0;
        this.repeatCountESet = false;
    }

    public void unsetSequenceNumber() {
        this.sequenceNumber = 0L;
        this.sequenceNumberESet = false;
    }

    public void unsetSeverity() {
        this.severity = 0;
        this.severityESet = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws ValidationException {
        CommonBaseEventImpl commonBaseEventImpl = this;
        synchronized (commonBaseEventImpl) {
            ListIterator iterator;
            if (this.sourceComponentId == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString((String)"LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", (Object)"CommonBaseEvent.SourceComponentId"));
            }
            if (this.situation == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString((String)"LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", (Object)"CommonBaseEvent.Situation"));
            }
            if (this.creationTime == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString((String)"LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", (Object)"CommonBaseEvent.CreationTime"));
            }
            if (this.repeatCount > 0 && !this.isSetElapsedTime()) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", (Object)"CommonBaseEvent.ElapsedTime"));
            }
            if (this.version != null && !this.version.equals("1.0.1")) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_VERSION_EXC_", (Object)"CommonBaseEvent.Version", (Object)this.version));
            }
            if (this.localInstanceId != null && this.localInstanceId.length() > 128) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.LocalInstanceId", (Object)this.localInstanceId, (Object)new Integer(this.localInstanceId.length()), (Object)new Integer(128)));
            }
            if (this.extensionName != null && this.extensionName.length() > 64) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ExtensionName", (Object)this.extensionName, (Object)new Integer(this.extensionName.length()), (Object)new Integer(64)));
            }
            if (this.msg != null && this.msg.length() > 1024) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.Msg", (Object)this.msg, (Object)new Integer(this.msg.length()), (Object)new Integer(1024)));
            }
            if (this.globalInstanceId != null) {
                if (this.globalInstanceId.length() < 32 || this.globalInstanceId.length() > 64) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_", (Object)"CommonBaseEvent.GlobalInstanceId", (Object)this.globalInstanceId));
                }
                if (!Character.isLetter(this.globalInstanceId.charAt(0))) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_", (Object)"CommonBaseEvent.GlobalInstanceId", (Object)this.globalInstanceId));
                }
            }
            try {
                if (LoggingCoreUtilities.convertXsdDateTimeToMilliseconds((String)this.creationTime) == 0L) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_CREATION_TIME_EXC_", (Object)"CommonBaseEvent.CreationTime", (Object)this.creationTime));
            }
            if (this.severityESet && (this.severity < 0 || this.severity > 70)) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_VALUE_OUT_OF_RANGE_EXC_", (Object)new Short(this.severity), (Object)"CommonBaseEvent.Severity", (Object)new Short(0), (Object)new Short(70)));
            }
            if (this.priorityESet && (this.priority < 0 || this.priority > 100)) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_VALUE_OUT_OF_RANGE_EXC_", (Object)new Short(this.priority), (Object)"CommonBaseEvent.Priority", (Object)new Short(0), (Object)new Short(100)));
            }
            if (this.repeatCountESet && this.repeatCount < 0) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_VALUE_OUT_OF_RANGE_EXC_", (Object)new Short(this.repeatCount), (Object)"CommonBaseEvent.RepeatCount", (Object)new Short(0), (Object)new Short(Short.MAX_VALUE)));
            }
            if (this.elapsedTimeESet && this.elapsedTime < 0L) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_VALUE_OUT_OF_RANGE_EXC_", (Object)new Long(this.elapsedTime), (Object)"CommonBaseEvent.ElapsedTime", (Object)new Long(0L), (Object)new Long(Long.MAX_VALUE)));
            }
            if (this.sequenceNumberESet && this.sequenceNumber < 0L) {
                throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_VALUE_OUT_OF_RANGE_EXC_", (Object)new Long(this.sequenceNumber), (Object)"CommonBaseEvent.SequenceNumber", (Object)new Long(0L), (Object)new Long(Long.MAX_VALUE)));
            }
            if (this.reporterComponentId != null) {
                this.reporterComponentId.validate();
            }
            if (this.msgDataElement != null) {
                this.msgDataElement.validate();
            }
            this.sourceComponentId.validate();
            this.situation.validate();
            if (this.contextDataElements != null) {
                iterator = this.contextDataElements.listIterator();
                ContextDataElement contextDataElement = null;
                while (iterator.hasNext()) {
                    contextDataElement = (ContextDataElement)iterator.next();
                    try {
                        contextDataElement.validate();
                    }
                    catch (ValidationException v) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_", (Object)"CommonBaseEvent.ContextDataElement".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]")), v);
                    }
                }
            }
            if (this.associatedEvents != null) {
                iterator = this.associatedEvents.listIterator();
                AssociatedEvent associatedEvent = null;
                while (iterator.hasNext()) {
                    associatedEvent = (AssociatedEvent)iterator.next();
                    try {
                        associatedEvent.validate();
                    }
                    catch (ValidationException v) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_", (Object)"CommonBaseEvent.AssociatedEvent".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]")), v);
                    }
                }
            }
            if (this.extendedDataElements != null) {
                iterator = this.getExtendedDataElements().listIterator();
                ExtendedDataElement extendedDataElement = null;
                while (iterator.hasNext()) {
                    extendedDataElement = (ExtendedDataElement)iterator.next();
                    try {
                        extendedDataElement.validate();
                    }
                    catch (ValidationException v) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_", (Object)"CommonBaseEvent.ExtendedDataElement".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]")), v);
                    }
                }
            }
        }
    }

    public String externalizeCanonicalXmlString() {
        return EventFormatter.toCanonicalXMLString(this);
    }

    public String externalizeCanonicalXmlDocString() {
        return EventFormatter.toCanonicalXMLDocString(this);
    }

    public void internalizeCanonicalXmlString(String value) {
        try {
            CommonBaseEvent event = EventFormatter.eventFromCanonicalXML(value);
            if (event != null) {
                TemplateContentHandlerImpl contentHandler = new TemplateContentHandlerImpl();
                contentHandler.setTemplateEvent(event);
                this.setContentHandler(contentHandler);
                this.complete();
                this.setContentHandler(null);
            }
        }
        catch (Exception exception) {}
    }

    public void internalizeCanonicalXmlDocString(String value) {
        try {
            CommonBaseEvent[] events = EventFormatter.eventsFromCanonicalXMLDoc(value);
            if (events != null && events[0] != null) {
                TemplateContentHandlerImpl contentHandler = new TemplateContentHandlerImpl();
                contentHandler.setTemplateEvent(events[0]);
                this.setContentHandler(contentHandler);
                this.complete();
                this.setContentHandler(null);
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        CommonBaseEventImpl commonBaseEventImpl = this;
        synchronized (commonBaseEventImpl) {
            int counter;
            CommonBaseEventImpl copy = (CommonBaseEventImpl)super.clone();
            if (this.creationTime != null) {
                copy.setCreationTime(new String(this.creationTime));
            }
            if (this.extensionName != null) {
                copy.setExtensionName(new String(this.extensionName));
            }
            if (this.globalInstanceId != null) {
                copy.setGlobalInstanceId(new String(this.globalInstanceId));
            }
            if (this.localInstanceId != null) {
                copy.setLocalInstanceId(new String(this.localInstanceId));
            }
            if (this.msg != null) {
                copy.setMsg(new String(this.msg));
            }
            if (this.version != null) {
                copy.setVersion(new String(this.version));
            }
            if (this.contextDataElements != null) {
                copy.contextDataElements = new ArrayList();
                counter = 0;
                while (counter < this.contextDataElements.size()) {
                    try {
                        copy.addContextDataElement((ContextDataElement)((ContextDataElementImpl)this.contextDataElements.get(counter)).clone());
                    }
                    catch (ClassCastException classCastException) {}
                    ++counter;
                }
            }
            if (this.extendedDataElements != null) {
                copy.extendedDataElements = new ArrayList();
                counter = 0;
                while (counter < this.extendedDataElements.size()) {
                    try {
                        copy.addExtendedDataElement((ExtendedDataElement)((ExtendedDataElementImpl)this.extendedDataElements.get(counter)).clone());
                    }
                    catch (ClassCastException classCastException) {}
                    ++counter;
                }
            }
            if (this.any != null) {
                copy.any = new ArrayList();
                counter = 0;
                while (counter < this.any.size()) {
                    try {
                        copy.addAny(new String((String)this.any.get(counter)));
                    }
                    catch (ClassCastException classCastException) {}
                    ++counter;
                }
            }
            if (this.associatedEvents != null) {
                copy.associatedEvents = new ArrayList();
                counter = 0;
                while (counter < this.associatedEvents.size()) {
                    try {
                        copy.addAssociatedEvent((AssociatedEvent)((AssociatedEventImpl)this.associatedEvents.get(counter)).clone());
                    }
                    catch (ClassCastException classCastException) {}
                    ++counter;
                }
            }
            if (this.msgDataElement != null) {
                try {
                    copy.setMsgDataElement((MsgDataElement)((MsgDataElementImpl)this.msgDataElement).clone());
                }
                catch (ClassCastException classCastException) {}
            }
            if (this.situation != null) {
                try {
                    copy.setSituation((Situation)((SituationImpl)this.situation).clone());
                }
                catch (ClassCastException classCastException) {}
            }
            if (this.sourceComponentId != null) {
                try {
                    copy.setSourceComponentId((ComponentIdentification)((ComponentIdentificationImpl)this.sourceComponentId).clone());
                }
                catch (ClassCastException classCastException) {}
            }
            if (this.reporterComponentId != null) {
                try {
                    copy.setReporterComponentId((ComponentIdentification)((ComponentIdentificationImpl)this.reporterComponentId).clone());
                }
                catch (ClassCastException classCastException) {}
            }
            if (this.msgDataElement != null) {
                try {
                    copy.setMsgDataElement((MsgDataElement)((MsgDataElementImpl)this.msgDataElement).clone());
                }
                catch (ClassCastException classCastException) {}
            }
            return copy;
        }
    }

    public void init() {
        this.unsetElapsedTime();
        this.unsetPriority();
        this.unsetRepeatCount();
        this.unsetSequenceNumber();
        this.unsetSeverity();
        this.setCreationTime(null);
        this.setExtensionName(null);
        this.setLocalInstanceId(null);
        this.setMsg(null);
        this.setVersion(null);
        this.setGlobalInstanceId(null);
        this.clearExtendedDataElements();
        this.clearContextDataElements();
        this.clearAssociatedEvents();
        this.clearAny();
        this.setSituation(null);
        this.setMsgDataElement(null);
        this.setReporterComponentId(null);
        this.setSourceComponentId(null);
        this.isComplete = false;
    }
}

