/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.internal.logging.datamgr.client.CBEClient;
import org.eclipse.cosmos.examples.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;

public class CBEDataSourceOutputter
extends AbstractOutputter {
    private static Logger logger = Logger.getLogger(CBEDataSourceOutputter.class);

    public void render(PrintWriter output, IParameters input) throws Exception {
        String title = input.getParameter("title");
        String prop = input.getParameter("prop");
        String eprparm = input.getParameter("epr");
        Collection cbe_coll = null;
        CBEClient dmc = new CBEClient(eprparm);
        if (dmc == null) {
            throw new CosmosException(Messages.getString("CBEDataSourceOutputter.3"));
        }
        if (prop != null && prop.equalsIgnoreCase("true")) {
            try {
                cbe_coll = dmc.getAllCBE(title);
            }
            catch (CosmosException ex) {
                throw new CosmosException(String.valueOf(Messages.getString("CBEDataSourceOutputter.5")) + title, (Throwable)ex);
            }
            if (cbe_coll != null) {
                Iterator I_cbe = cbe_coll.iterator();
                output.print("[");
                while (I_cbe.hasNext()) {
                    CommonBaseEvent cbe = (CommonBaseEvent)I_cbe.next();
                    output.print("\t[ \"Name\", '" + title + "'],");
                    output.print("\t[ \"Creation Time\", '" + cbe.getCreationTime().replace('T', ' ') + "'],");
                    output.print("\t[ \"Extension Name\", '" + cbe.getExtensionName() + "'],");
                    output.print("\t[ \"SubComponent\", '" + cbe.getSourceComponentId().getSubComponent() + "'],");
                    output.print("\t[ \"Location\", '" + cbe.getSourceComponentId().getLocation() + "']");
                }
                output.print("]");
            } else {
                logger.warn((Object)(String.valueOf(Messages.getString("CBEDataSourceOutputter.18")) + title));
            }
        } else {
            Collection dsn_coll = null;
            try {
                dsn_coll = dmc.getDatasets();
            }
            catch (CosmosException ex) {
                throw new CosmosException(Messages.getString("CBEDataSourceOutputter.19"), (Throwable)ex);
            }
            if (dsn_coll != null) {
                Iterator I_dsn = null;
                String dsn = null;
                output.print("{ identifier: \"object\",  label: \"title\",  items:[");
                I_dsn = dsn_coll.iterator();
                while (I_dsn.hasNext()) {
                    dsn = (String)I_dsn.next();
                    output.print("{nodeClass:\"datasource\", title:\"" + dsn + "\", logfile:\"" + dsn + "\", epr:'" + eprparm + "', classification:\"CBE\"");
                    output.print(", store:[");
                    output.print("['epr', '" + eprparm + "']");
                    output.print(",['logfile', '" + dsn + "']");
                    output.print("]}");
                    if (!I_dsn.hasNext()) continue;
                    output.print(",");
                }
                output.print("]}");
            }
        }
    }
}

