/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: IOutputterContext.java,v 1.2 2008/01/04 21:44:30 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.provisional.dr.drs.service.handler.common;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;

import javax.servlet.ServletContext;

public interface IOutputterContext {
	public abstract ServletContext getContext(String arg0);

	public abstract String getInitParameter(String paramid);

	public abstract Enumeration getInitParameterNames();

	public abstract URL getResource(String resource) throws MalformedURLException;

	public abstract InputStream getResourceAsStream(String resource);

	public abstract Set getResourcePaths(String path);

	public abstract void log(String message, Throwable error);

	public abstract void log(String message);

	public abstract String getRealPath(String path);
	
	public abstract IStore getStore();
	
	public abstract Locale getLocale();
}
