/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ConditionType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalDerivedVariablesType
implements Comparator<ConditionalDerivedVariable> {
    private static ConditionalDerivedVariablesType instance;

    static Collection<ConditionalDerivedVariable> merge(Collection<ConditionalDerivedVariable> coll1, Collection<ConditionalDerivedVariable> coll2) {
        TreeSet<ConditionalDerivedVariable> merged = new TreeSet<ConditionalDerivedVariable>();
        TreeSet<ConditionalDerivedVariable> left = new TreeSet<ConditionalDerivedVariable>(ConditionalDerivedVariablesType.getInstance());
        TreeSet<ConditionalDerivedVariable> right = new TreeSet<ConditionalDerivedVariable>(ConditionalDerivedVariablesType.getInstance());
        left.addAll(coll1);
        left.addAll(coll2);
        for (ConditionalDerivedVariable varLeft : left) {
            ConditionalDerivedVariable varRight2 = null;
            boolean matches = false;
            for (ConditionalDerivedVariable varRight2 : right) {
                if (!ConditionalDerivedVariablesType.equals(varLeft, varRight2)) continue;
                matches = true;
                break;
            }
            if (matches) {
                merged.add(varRight2);
                Set above = right.subSet((ConditionalDerivedVariable)right.first(), varRight2);
                merged.addAll(above);
                above.clear();
                right.remove(varRight2);
                continue;
            }
            merged.add(varLeft);
        }
        if (right.size() > 0) {
            merged.addAll(right);
        }
        return merged;
    }

    private static boolean equals(ConditionalDerivedVariable var1, ConditionalDerivedVariable var2) {
        boolean equal = true;
        ConditionalDerivedVariableExpression expression1 = (ConditionalDerivedVariableExpression)var1.getConditionalDerivedExpressions().iterator().next();
        ConditionalDerivedVariableExpression expression2 = (ConditionalDerivedVariableExpression)var2.getConditionalDerivedExpressions().iterator().next();
        equal = equal && ConditionType.equals(expression1.getCondition(), expression2.getCondition());
        equal = equal && StringType.equals(expression1.getExpression(), expression2.getExpression());
        return equal;
    }

    @Override
    public int compare(ConditionalDerivedVariable var1, ConditionalDerivedVariable var2) {
        ConditionalDerivedVariableExpression expression1 = (ConditionalDerivedVariableExpression)var1.getConditionalDerivedExpressions().iterator().next();
        ConditionalDerivedVariableExpression expression2 = (ConditionalDerivedVariableExpression)var2.getConditionalDerivedExpressions().iterator().next();
        BigInteger priority1 = expression1.getPriority();
        BigInteger priority2 = expression2.getPriority();
        int comparison = priority1 != null && priority2 == null ? 1 : (priority1 == null && priority2 != null ? -1 : (priority1 != null && priority2 != null ? priority2.compareTo(priority1) : 0));
        return comparison;
    }

    private static synchronized ConditionalDerivedVariablesType getInstance() {
        if (instance == null) {
            instance = new ConditionalDerivedVariablesType();
        }
        return instance;
    }
}

