/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.MapParameterImpl;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IIDResolver;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class QueriesOutputter
extends AbstractOutputter {
    public static final String NODECLASS = "nodeClass";
    protected String rootDir = "";
    protected String repoDir = "";

    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        this.rootDir = context.getRealPath("queries");
        this.repoDir = context.getRealPath("queryRepository" + File.separator + "queries");
        super.initalize(context, parameters);
    }

    public void render(PrintWriter writer, IParameters input) throws Exception {
        String nodeClass = input.getParameter(NODECLASS);
        String bundleName = this.context.getInitParameter("WIDGET_BUNDLE_NAME");
        String[] bundles = bundleName.split(",");
        ResourceBundle[] RESOURCE_BUNDLES = new ResourceBundle[bundles.length];
        int x = 0;
        while (x < bundles.length) {
            RESOURCE_BUNDLES[x] = ResourceBundle.getBundle(bundles[x]);
            ++x;
        }
        if (nodeClass != null) {
            String[] tags = nodeClass.split(",");
            int count = 0;
            writer.write("{");
            int y = 0;
            while (y < tags.length) {
                String genRepoFilename;
                String genFilename = this.generateFilename(tags[y]);
                File[] files = new File[]{};
                File[] repoFiles = new File[]{};
                File fileExists = new File(genFilename);
                if (fileExists.exists() && fileExists.isDirectory()) {
                    FileFilter fileFilter = new FileFilter(){

                        public boolean accept(File file) {
                            return file.isFile() && file.getName().endsWith("jprop");
                        }
                    };
                    files = fileExists.listFiles(fileFilter);
                }
                if ((fileExists = new File(genRepoFilename = this.generateRepoFilename(tags[y]))).exists() && fileExists.isDirectory()) {
                    FileFilter fileFilter = new FileFilter(){

                        public boolean accept(File file) {
                            return file.isFile() && file.getName().endsWith("jprop");
                        }
                    };
                    repoFiles = fileExists.listFiles(fileFilter);
                }
                if (files.length > 0 || repoFiles.length > 0) {
                    if (count > 0) {
                        writer.write(",");
                    }
                    writer.write("\"" + tags[y] + "\":[");
                    int fileCount = 0;
                    int x2 = 0;
                    while (x2 < files.length) {
                        if (fileCount > 0) {
                            writer.append(",");
                        }
                        this.generateJSON(files[x2].getAbsolutePath(), writer, RESOURCE_BUNDLES, true);
                        ++fileCount;
                        ++x2;
                    }
                    x2 = 0;
                    while (x2 < repoFiles.length) {
                        if (fileCount > 0) {
                            writer.append(",");
                        }
                        this.generateJSON(repoFiles[x2].getAbsolutePath(), writer, RESOURCE_BUNDLES, false);
                        ++fileCount;
                        ++x2;
                    }
                    writer.write("]");
                    ++count;
                }
                ++y;
            }
            writer.write("}");
        } else {
            writer.write("[]");
        }
    }

    protected String generateFilename(String tag) {
        String[] tags = tag.split(" ");
        String newFileName = String.valueOf(this.rootDir) + File.separator;
        int x = 0;
        while (x < tags.length) {
            newFileName = String.valueOf(newFileName) + tags[x] + File.separator;
            ++x;
        }
        return newFileName;
    }

    protected String generateRepoFilename(String tag) {
        String[] tags = tag.split(" ");
        String newFileName = String.valueOf(this.repoDir) + File.separator;
        int x = 0;
        while (x < tags.length) {
            newFileName = String.valueOf(newFileName) + tags[x] + File.separator;
            ++x;
        }
        return newFileName;
    }

    protected void generateQueryJSON(String filename, Writer writer) throws Exception {
        File file = new File(filename);
        if (file.isFile()) {
            writer.write(", query:\"");
            FileInputStream fis = null;
            ByteArrayOutputStream bos = null;
            try {
                int i;
                fis = new FileInputStream(filename);
                bos = new ByteArrayOutputStream();
                while ((i = fis.read()) != -1) {
                    bos.write(i);
                }
                fis.close();
                writer.write(QueriesOutputter.escapeForMarkup(bos.toByteArray()));
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            writer.write("\"");
        }
    }

    protected void generateJSON(String filename, Writer writer, ResourceBundle[] RESOURCE_BUNDLE, boolean readonly) throws Exception {
        FileInputStream fis = null;
        writer.write("{readonly:" + readonly + ",meta:");
        try {
            int c;
            fis = new FileInputStream(filename);
            boolean macroStart = false;
            boolean macroStart2 = false;
            StringBuffer macroBuffer = null;
            while ((c = fis.read()) != -1) {
                if (macroStart) {
                    if ((char)c == '{') {
                        macroBuffer = new StringBuffer();
                        macroStart2 = true;
                    } else {
                        writer.write(36);
                        macroBuffer = null;
                    }
                    macroStart = false;
                }
                if ((char)c == '$') {
                    macroStart = true;
                }
                if (macroBuffer != null) {
                    if ((char)c == '}') {
                        String macroValue = "${" + macroBuffer.toString() + "}";
                        int x = 0;
                        while (x < RESOURCE_BUNDLE.length) {
                            try {
                                macroValue = RESOURCE_BUNDLE[x].getString(macroBuffer.toString());
                            }
                            catch (MissingResourceException missingResourceException) {}
                            ++x;
                        }
                        if (macroValue == null) {
                            macroValue = "${" + macroBuffer.toString() + "}";
                        }
                        writer.write(macroValue);
                        macroBuffer = null;
                        continue;
                    }
                    if (!macroStart2) {
                        macroBuffer.append((char)c);
                        continue;
                    }
                    if (!macroStart2) continue;
                    macroStart2 = false;
                    continue;
                }
                if (macroStart) continue;
                writer.write(c);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        this.generateQueryJSON(String.valueOf(filename.substring(0, filename.length() - "jprop".length())) + "query", writer);
        writer.write("}");
    }

    public static String escapeForMarkup(byte[] buffer) {
        if (buffer == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = buffer.length;
        int i = 0;
        while (i < len) {
            char c = (char)buffer[i];
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\n': {
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public void setIdResolver(IIDResolver idResolver) {
    }

    public static final void main(String[] argv) throws Exception {
        PrintWriter pw = new PrintWriter(System.out);
        QueriesOutputter out = new QueriesOutputter();
        out.rootDir = "D:\\development\\wtp30\\eclipse\\workspace\\org.eclipse.cosmos.dr.tests.views\\WebContent\\queries";
        HashMap<String, String> input = new HashMap<String, String>();
        input.put(NODECLASS, "mdrExample");
        out.render(pw, new MapParameterImpl(input));
        pw.flush();
        pw.close();
    }
}

