/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.logging.core.internationalization;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

final class JavaInternationalizationUtilities {
    JavaInternationalizationUtilities() {
    }

    protected static String format(long milliseconds, String dateFormatPattern, Locale locale, String timeZoneID) throws IllegalArgumentException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatPattern, Locale.ENGLISH);
        simpleDateFormat.setCalendar(new GregorianCalendar(TimeZone.getTimeZone(timeZoneID)));
        return simpleDateFormat.format(new Date(milliseconds));
    }

    protected static String format(String message, Object[] arguments, Locale locale) throws IllegalArgumentException {
        return new MessageFormat(message, locale).format(arguments);
    }

    protected static String[] tokenize(String string, String delimiters) {
        String[] tokens = null;
        if (string != null) {
            StringTokenizer tokenizer = new StringTokenizer(string, delimiters);
            tokens = new String[tokenizer.countTokens()];
            int counter = 0;
            while (counter < tokens.length) {
                tokens[counter] = tokenizer.nextToken();
                ++counter;
            }
        }
        return tokens;
    }

    protected static char charAt(String string, int index) throws IndexOutOfBoundsException, NullPointerException {
        return string.charAt(index);
    }
}

