/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.smlvalidators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationMessage;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.ReferenceExtractor;
import org.eclipse.cosmos.rm.internal.validation.reference.ReferenceContext;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;
import org.eclipse.cosmos.rm.internal.validation.reference.XPointer;
import org.eclipse.cosmos.rm.internal.validation.reference.XPointerExpression;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceValidator
extends AbstractSMLValidator {
    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.getInstanceLevelRegistry();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceExtractor", new ReferenceExtractor());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationReferences);
        ReferenceExtractor referenceExtractor = (ReferenceExtractor)DataBuilderRegistry.getInstanceLevelRegistry().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceExtractor");
        List<ReferenceContext> referenceContextList = referenceExtractor.getContextReferences();
        Node lastNode = null;
        ReferenceDescriptor lastReference = null;
        int i = 0;
        int refContextCount = referenceContextList.size();
        while (i < refContextCount) {
            ReferenceContext referenceContext = referenceContextList.get(i);
            if (!referenceContext.isNilref()) {
                Node contextNode = SMLValidatorUtil.locateDocumentNode(referenceContext.getAliases(), referenceContext.getDocumentPosition());
                List<ReferenceDescriptor> referenceDescriptors = referenceContext.getReferenceDescriptors();
                int j = 0;
                int referenceDescCount = referenceDescriptors.size();
                while (j < referenceDescCount) {
                    ReferenceDescriptor currentReference = null;
                    try {
                        currentReference = referenceDescriptors.get(j);
                        URIReference uriReference = new URIReference(contextNode, currentReference.getReference(), currentReference.getBaseURI());
                        Node context = uriReference.retrieveDocumentDOM();
                        Node node = null;
                        if (context == null) {
                            this.showWarning(currentReference, SMLValidationMessages.warningUnresolvedReferenceDocument, new String[]{currentReference.getReference(), uriReference.getDocumentReference()});
                        } else {
                            XPointerExpression xpointerExpression;
                            String fragment = uriReference.getFragment();
                            if (fragment != null && fragment.length() > 0 && (node = (xpointerExpression = XPointer.compile(uriReference.getFragment())).evaluate(referenceContext.getNamespaceContext(), context)) == null) {
                                this.showWarning(currentReference, SMLValidationMessages.warningUnresolvedReferenceFragment, new String[]{currentReference.getReference()});
                            }
                        }
                        if (j == 0) {
                            lastNode = node;
                            lastReference = currentReference;
                        } else if (lastNode == null && node != null || lastNode != null && node == null || lastNode != null && node != null && !lastNode.equals(node)) {
                            this.showError(lastReference, currentReference);
                            if (this.shouldAbortOnError()) {
                                return false;
                            }
                        }
                    }
                    catch (URISyntaxException e) {
                        String message = e.getMessage().trim();
                        if (message.endsWith(":")) {
                            message = message.substring(0, message.length() - 1);
                        }
                        message = String.valueOf(NLS.bind((String)SMLValidationMessages.errorReferenceResolving, (Object[])new String[]{currentReference.getReference()})) + " " + message;
                        this.showError(message, currentReference);
                    }
                    catch (Exception e) {
                        this.showError(SMLValidationMessages.errorReferenceResolving, currentReference, e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private void showError(ReferenceDescriptor lastReference, ReferenceDescriptor currentReference) {
        this.showError(NLS.bind((String)SMLValidationMessages.errorInconsistentReference, (Object[])new String[]{lastReference.getReference(), currentReference.getReference()}), lastReference);
    }

    private void showError(String message, ReferenceDescriptor uriReference, Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.showMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(uriReference.getFilePath(), uriReference.getLineNumber(), String.valueOf(NLS.bind((String)message, (Object)uriReference.getReference())) + " " + sw.getBuffer().toString()));
    }

    private void showError(String message, ReferenceDescriptor reference) {
        this.showMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(reference.getFilePath(), reference.getLineNumber(), message));
    }

    private void showWarning(ReferenceDescriptor uriReference, String message, String[] fillIns) {
        this.showMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(uriReference.getFilePath(), uriReference.getLineNumber(), NLS.bind((String)message, (Object[])fillIns)));
    }

    private void showMessage(IValidationMessage validationMessage) {
        IValidationOutput<String, Object> output = this.getValidationOutput();
        output.reportMessage(validationMessage);
    }
}

