/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;

/**
 * A target element node that embedded in a complex type.  Storing
 * the enclosing type allows us to determine whether those types
 * have a hierachical relationship with each other.
 * 
 * @author David Whiteman
 */
public class EmbeddedTargetElementNode extends TargetElementNode {

	/**
	 * Xerces model object for the complex type that contains this element node
	 */
	private XSComplexTypeDefinition enclosingType;
	/**
	 * Xerces model object for the element node
	 */
	private XSElementDeclaration elementDeclaration;

	public EmbeddedTargetElementNode() {
	}

	public EmbeddedTargetElementNode(XSElementDeclaration elementDeclaration, XSComplexTypeDefinition enclosingType, String targetUri, byte targetType) {
		super();
		setElementDeclaration(elementDeclaration);
		setName(elementDeclaration.getName());
		setUri(elementDeclaration.getNamespace());
		setEnclosingType(enclosingType);
		setTargetURI(targetUri);
		setTargetURIType(targetType);
	}

	public XSElementDeclaration getElementDeclaration() {
		return elementDeclaration;
	}

	public void setElementDeclaration(XSElementDeclaration elementDeclaration) {
		this.elementDeclaration = elementDeclaration;
	}

	public void setEnclosingType(XSComplexTypeDefinition enclosingType) {
		this.enclosingType = enclosingType;
	}

	public XSComplexTypeDefinition getEnclosingType() {
		return enclosingType;
	}

	public String getQualifiedName() {
		return SMLValidatorUtil.createQualifiedName(getUri(), getName());
	}
}
