/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Descriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.w3c.dom.Document;

public abstract class DescriptorImpl
extends SPIDataObject
implements Descriptor {
    Document document = null;

    public DescriptorImpl(Document doc, SPISessionImpl session, String sddSchemaType) {
        super(doc.getDocumentElement(), session, sddSchemaType);
        this.document = doc;
    }

    public byte[] getDescriptorID() {
        byte[] descriptorID = null;
        String idAttribute = this.getAttribute("descriptorID");
        if (idAttribute != null) {
            descriptorID = ConversionUtil.hexToBytes(idAttribute);
        }
        return descriptorID;
    }

    public Date getLastModified() {
        Date date = null;
        if (this.isSetAttribute("lastModified")) {
            String dateString = this.getAttribute("lastModified");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ");
            String timeZone = null;
            if (dateString.length() == 25) {
                timeZone = String.valueOf(dateString.substring(19, 22)) + dateString.substring(23);
            } else if (dateString.endsWith("Z")) {
                timeZone = "-0000";
                dateString = dateString.substring(0, dateString.length() - 1);
            } else {
                SimpleDateFormat tzf = new SimpleDateFormat("Z");
                timeZone = tzf.format(Calendar.getInstance().getTime());
            }
            try {
                date = df.parse(String.valueOf(dateString) + timeZone);
            }
            catch (ParseException parseException) {}
        }
        return date;
    }

    public String getSchemaVersion() {
        return this.getAttribute("schemaVersion");
    }

    public void setDescriptorID(byte[] descriptorID) {
        this.session.testParameter(descriptorID, 1, null);
        if (descriptorID != null && descriptorID.length != 16) {
            throw new InvalidInputException(1, 4);
        }
        this.setAttribute("descriptorID", ConversionUtil.bytesToHex(descriptorID));
    }

    public void setLastModified(Date lastModified) {
        this.session.testParameter(lastModified, 1, null);
        String formattedDate = null;
        if (lastModified != null) {
            SimpleDateFormat tzf = new SimpleDateFormat("Z");
            String timeZone = tzf.format(lastModified);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
            formattedDate = String.valueOf(df.format(lastModified)) + timeZone.substring(0, 3) + ":" + timeZone.substring(3);
        }
        this.setAttribute("lastModified", formattedDate);
    }

    public void setSchemaVersion(String schemaVersion) {
        this.session.testParameter(schemaVersion, 1, null);
        this.setAttribute("schemaVersion", schemaVersion);
    }

    public String toString() {
        String description = new String("Descriptor ID: " + this.getDescriptorID() + " - Schema Version: " + this.getSchemaVersion() + " - LastModified: " + this.getLastModified() + "\n");
        return description;
    }

    public Document getOwnerDocument() {
        return this.document;
    }
}

