/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.rpm;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cosmos.me.internal.deployment.sdd.resources.tooling.btg.rpm.Messages;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.rpm.RPMReader;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataCollector;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.util.BTGLogUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPMDataCollector
implements IBTGDataCollector {
    private static Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg");
    private static Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg.stdout");

    public Collection<SDDFragment> collectSDDData(Properties properties) {
        RPMReader rpmReader = null;
        try {
            rpmReader = new RPMReader(properties.getProperty("FileName"));
        }
        catch (MalformedURLException e) {
            consoleLogger.severe(Messages.getString("RPMDataCollector.1"));
            consoleLogger.log(Level.INFO, Messages.getString("RPMDataCollector.2"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, Messages.getString("RPMDataCollector.3"), e);
            return null;
        }
        catch (IOException e) {
            consoleLogger.severe(Messages.getString("RPMDataCollector.4"));
            consoleLogger.log(Level.INFO, Messages.getString("RPMDataCollector.2"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, Messages.getString("RPMDataCollector.3"), e);
            return null;
        }
        ArrayList<SDDFragment> sddFragments = new ArrayList<SDDFragment>();
        Properties pdProperties = new Properties();
        pdProperties.put("FileName", properties.getProperty("FileName"));
        PackageDescriptor pd = rpmReader.getPackageDescriptor();
        Document pdDoc = pd.getOwnerDocument();
        sddFragments.add(new SDDFragment(pdDoc, (Object)pdProperties));
        Properties ddProperties = new Properties();
        ddProperties.put("FileName", properties.getProperty("FileName"));
        DeploymentDescriptor dd = rpmReader.getDeploymentDescriptor();
        Document ddDoc = dd.getOwnerDocument();
        sddFragments.add(new SDDFragment(ddDoc, (Object)ddProperties));
        return sddFragments;
    }

    public Collection<BTGProperty> getSupportedProperties() {
        ArrayList<BTGProperty> properties = new ArrayList<BTGProperty>();
        properties.add(new BTGProperty("FileName", true));
        return properties;
    }
}

