/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.xmldsig.SignatureImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.Signature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PackageDescriptorImpl extends DescriptorImpl implements PackageDescriptor {
	private static final String PACKAGE_DESCRIPTOR_TYPE = "sdd-pd:PackageDescriptorType";
	private static final String CONTENTS_TYPE = "sdd-pd:ContentsType";

	public PackageDescriptorImpl(Document doc, SPISessionImpl session) {
		super(doc, session, PACKAGE_DESCRIPTOR_TYPE);
	}

	public Collection<PackageContent> getPackageContents() {
		Collection<PackageContent> packageContents = null;
		
		if (isSetElement("Contents")) {
			packageContents = new ArrayList<PackageContent>();
			Collection<Element> contentElements = session.getChildren(getChild("Contents"), "Content");
			
			for (Element contentElement : contentElements)
            {
				packageContents.add(new PackageContentImpl(contentElement, session));
			}
		}
		
		return packageContents;
	}

	public Signature getSignature() {
		if (isSetElement("Signature")) {
			return new SignatureImpl(getChild("Signature"), session);
		}
		else {
			return null;
		}
	}

	public void setPackageContents(Collection<PackageContent> aPackageContents) {
		session.testParameter(aPackageContents, 1, null);
		
		if (aPackageContents != null) {
			Element contentsElement = session.createPackageElement("Contents");
			
			for (PackageContent packageContent : aPackageContents) {
				Element contentElement = ((SPIDataObject)packageContent).getElement();
				session.insertNode(contentsElement, contentElement, CONTENTS_TYPE);
			}
			
			setContent(contentsElement);
		}
		else {
			unSetElement("Contents");	
		}
	}

	public PackageIdentity getPackageIdentity() {
		if (isSetElement("PackageIdentity")) {
			return new PackageIdentityImpl(getChild("PackageIdentity"), session);
		}
		else {
			return null;
		}
	}
	
	public void setPackageIdentity(PackageIdentity packageIdentity) {
		session.testParameter(packageIdentity, 1, null);
		
		if (packageIdentity != null) {
			setContent((SPIDataObject)packageIdentity);
		}
		else {
			unSetElement("PackageIdentity");	
		}
	}	

	public void setSignature(Signature signature) {
		if (signature == null) {
			unSetElement("Signature");
		}
		else {
			setContent((SPIDataObject)signature);
		}
	}

	public String toString() {
		String description = "Package Descriptor\n------------------\n" + super.toString() + "\n";
		
		if (isSetElement("PackageIdentity")) {
			description += getPackageIdentity() + "\n";
		}
		else {
			description += "Package Identity - not defined\n\n";
		}
		
		int i = 0;
		for (PackageContent packageContent : getPackageContents()) {
			description += "Content " + ++i + ": " + packageContent;
        }
		
		return description;
	}
	
	public Object clone() {
		return new PackageDescriptorImpl((Document)document.cloneNode(true), session);
	}
}
