/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.w3c.dom.Element;

public class VersionRangeImpl extends SPIDataObject implements VersionRange {
	private static final String VERSION_RANGE_TYPE = "sdd-dd:VersionRangeType";
    
    public VersionRangeImpl(Element data, SPISessionImpl session) {
        super(data, session, VERSION_RANGE_TYPE);
    }
    
    public Collection<String> getFixNames() {
    	Collection<Element> fixNameElements = getChildren("FixName");
    	Collection<String> fixNames = new ArrayList<String>();
    	
    	for (Element element : fixNameElements) {
    		fixNames.add(element.getTextContent());
    	}

    	return fixNames;
    }

    public String getMaximumVersion() {
    	if (isSetElement("MaxVersion")) {
    		Element maxVersion = getChild("MaxVersion");
    		
    		return maxVersion.getTextContent();
    	}
    	else {
    		return null;
    	}
    }

    public Boolean getMaximumVersionInclusiveness() {
    	if (isSetElement("MaxVersion") && getChild("MaxVersion").getAttribute("inclusive") != null) {
    		return Boolean.parseBoolean(getChild("MaxVersion").getAttribute("inclusive"));
    	}
    	else {
    		return null;
    	}
    }

    public String getMinimumVersion() {
    	if (isSetElement("MinVersion")) {
    		Element minVersion = getChild("MinVersion");
    		
    		return minVersion.getTextContent();
    	}
    	else {
    		return null;
    	}
    }

    public void setFixNames(Collection<String> fixNames) {
		removeContent(getChildren("FixName", false));
		Collection<Element> fixNameElements = new ArrayList<Element>();
		
		for (String fixName : fixNames) {
			Element fixNameElement = session.createDeploymentElement("FixName");
			fixNameElement.setTextContent(fixName);
			fixNameElements.add(fixNameElement);
		}
		
		addContent(fixNameElements);
    }

    public void setMaximumVersion(String maximumVersion) {
        if (maximumVersion == null) {
        	unSetElement("MaxVersion");
        }
        else {
    		Element maxVersionElement = session.createDeploymentElement("MaxVersion");
    		maxVersionElement.setTextContent(maximumVersion);

    		setContent(maxVersionElement);
    	}
    }

    public void setMaximumVersionInclusiveness(Boolean maximumVersionInclusiveness) {
    	if (!isSetElement("MaxVersion")) {
        	Element maxVersionElement = session.createDeploymentElement("MaxVersion");
        	setContent(maxVersionElement);
    	}
    	
    	Element maxVersionElement = getChild("MaxVersion");
    	
        if (maximumVersionInclusiveness == null) {
        	maxVersionElement.removeAttribute("inclusive");
        }
        else {
        	maxVersionElement.setAttribute("inclusive", maximumVersionInclusiveness.toString());
        }
        
        setContent(maxVersionElement);
    }

    public void setMinimumVersion(String minimumVersion) {
    	if (minimumVersion == null) {
    		unSetElement("MinVersion");
    	}
    	else {
    		Element minVersionElement = session.createDeploymentElement("MinVersion");
    		minVersionElement.setTextContent(minimumVersion);
    		
    		setContent(minVersionElement);
    	}    	
    }
    
    public String toString() {
        String versionRangeContents = "";
        if (isSetElement("MinVersion")) {
            versionRangeContents += " Min Version : " + getChild("MinVersion").getTextContent();
        }

        if (isSetElement("MaxVersion")) {
            versionRangeContents += " Max Version : " + getChild("MaxVersion").getTextContent();
        }

        return versionRangeContents;
    }

    public Object clone() {
    	return new VersionRangeImpl((Element)getElement().cloneNode(true), session);
    }
}