/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.w3c.dom.Element;

public class AlternativeRequiredBaseConstraintImpl extends NameableObject implements AlternativeRequiredBaseConstraint {
	private static final String ALTERNATIVE_REQUIRED_BASE_CONSTRAINT_TYPE = "sdd-dd:AlternativeRequiredBaseConstraintType";

	public AlternativeRequiredBaseConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, ALTERNATIVE_REQUIRED_BASE_CONSTRAINT_TYPE);
	}

	public String getID() {
		return getAttribute("id");
	}

	public BigInteger getPriority() {
		BigInteger priority = null;
		
		if (isSetAttribute("priority")) {
			priority = new BigInteger(getAttribute("priority"));
		}
		
		return priority;
	}

	public Collection<RequiredBaseConstraint> getRequiredBaseConstraints() {
		Collection<Element> requiredBaseElements = getChildren("ResourceConstraint");
		Collection<RequiredBaseConstraint> constraints = new ArrayList<RequiredBaseConstraint>();
		
		for (Element element : requiredBaseElements) {
			RequiredBaseConstraint constraint = new RequiredBaseConstraintImpl(element, session);
			constraints.add(constraint);
		}

		return constraints;
	}

	public void setID(String id) {
		session.testParameter(id, 1, null);
		
		setAttribute("id", id);
	}

	public void setPriority(BigInteger priority) {
		if (priority == null) {
			unSetAttribute("priority");
		}
		else {
			setAttribute("priority", priority.toString());
		}
	}

	public void setRequiredBaseConstraints(Collection<RequiredBaseConstraint> newRequiredBaseConstraints) {
		if (newRequiredBaseConstraints == null) {
			unSetElement("ResourceConstraint");
		}
		else {
			removeContent(getChildren("ResourceConstraint", false));
			
			addContent(newRequiredBaseConstraints);
		}
	}

	public Object clone() {
		return new AlternativeRequiredBaseConstraintImpl((Element)getElement().cloneNode(true), session);
	}
}
