/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.xmldsig;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.DigestMethod;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.Signature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.XmlDsigFactory;
import org.w3c.dom.Element;

public class XmlDsigFactoryImpl implements XmlDsigFactory {
	private SPISessionImpl session;
	
	public XmlDsigFactoryImpl(SPISessionImpl session) {
		this.session = session;
	}

	public DigestMethod createDigestMethod(String algorithm) {
		Element digestMethodElement = session.createXmlDsigElement("DigestMethod");
		digestMethodElement.setAttribute("Algorithm", algorithm);
		
		return new DigestMethodImpl(digestMethodElement, session);
	}
	
	public Signature createSignature() {
		Element signatureElement = session.createXmlDsigElement("Signature");
		
		return new SignatureImpl(signatureElement, session);
	}
}
