/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public class Resource_Test extends TestCase {
    Resource resource;
    Resource clonedResource;
    Element element;
    SPISessionImpl session;

    public Resource_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        
        resource = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResource("testResourceID", "testResourceType");
        resource.setDescription(new TranslatableString("testDescription", "testKey"));
        resource.setName("testName");
        resource.setShortDescription(new TranslatableString("testShortDescription", "testShortKey"));
        
        Resource hostedResource1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createHostedResource("testHosted1ResourceID", "testHosted1ResourceType");
        hostedResource1.setDescription(new TranslatableString("testHosted1Description", "testHosted1Key"));
        hostedResource1.setName("testHosted1Name");
        hostedResource1.setShortDescription(new TranslatableString("testHosted1ShortDescription", "testHosted1ShortKey"));

        Resource hostedResource2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createHostedResource("testHosted2ResourceID", "testHosted2ResourceType");
        hostedResource2.setDescription(new TranslatableString("testHosted2Description", "testHosted2Key"));
        hostedResource2.setName("testHosted2Name");
        hostedResource2.setShortDescription(new TranslatableString("testHosted2ShortDescription", "testHosted2ShortKey"));

        Resource hostedResource3 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createHostedResource("testHosted3ResourceID", "testHosted3ResourceType");
        hostedResource3.setDescription(new TranslatableString("testHosted3Description", "testHosted3Key"));
        hostedResource3.setName("testHosted3Name");
        hostedResource3.setShortDescription(new TranslatableString("testHosted3ShortDescription", "testHosted3ShortKey"));

        hostedResource1.setHostedResources(Arrays.asList(hostedResource3));
        resource.setHostedResources(Arrays.asList(hostedResource1, hostedResource2));
        
        Properties properties = new Properties();
        properties.setProperty("testKey1", "testValue1");
        properties.setProperty("testKey2", "testValue2");
        resource.setProperties(properties);
        
        clonedResource = (Resource)resource.clone();
        element = ((SPIDataObject)resource).getElement();
        session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetName() {
        assertEquals("testName", resource.getName());
        assertEquals("testName", clonedResource.getName());
        assertEquals("testName", session.getChildren(element, "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetResourceID() {
        assertEquals("testResourceID", resource.getResourceID());
        assertEquals("testResourceID", clonedResource.getResourceID());
        assertEquals("testResourceID", element.getAttribute("id"));
    }

    public void testGetResourceType() {
        assertEquals("testResourceType", resource.getResourceType());
        assertEquals("testResourceType", clonedResource.getResourceType());
        assertEquals("testResourceType", element.getAttribute("type"));
    }

    public void testGetProperties() {
        Properties testProps = resource.getProperties();
        Properties testclonedProps = clonedResource.getProperties();
        Collection<Element> testDataObjectProps = session.getChildren(element, "Property");
        
        assertEquals("testValue1", testProps.get("testKey1"));
        assertEquals("testValue2", testProps.get("testKey2"));
        assertEquals("testValue1", testclonedProps.get("testKey1"));
        assertEquals("testValue2", testclonedProps.get("testKey2"));
        
        assertEquals(2, testDataObjectProps.size());
        
        for (int i = 0; i < testDataObjectProps.size(); i++) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            
            String value = session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            
            assertTrue(value + " wasn't found in the properties object", testProps.contains(value));
            assertTrue(propertyName + " wasn't found in the properties object", testProps.containsKey(propertyName));
            assertEquals(value, testProps.get(propertyName));
        }
    }

    public void testGetHostedResources() {
        Collection<Resource> testHostedResources = resource.getHostedResources();
        Collection<Resource> testClonedHostedResources = clonedResource.getHostedResources();
        Collection<Element> testDataObjectHostedResources = session.getChildren(element, "HostedResource");
        
        assertEquals(2, testHostedResources.size());
        assertEquals(2, testClonedHostedResources.size());
        assertEquals(2, testDataObjectHostedResources.size());
        
        assertEquals("testHosted1Description", testHostedResources.toArray(new Resource[0])[0].getDescription().getValue());
        assertEquals("testHosted1Key", testHostedResources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        assertEquals("testHosted1Name", testHostedResources.toArray(new Resource[0])[0].getName());
        assertEquals("testHosted1ResourceID", testHostedResources.toArray(new Resource[0])[0].getResourceID());
        assertEquals("testHosted1ResourceType", testHostedResources.toArray(new Resource[0])[0].getResourceType());
        assertEquals("testHosted1ShortDescription", testHostedResources.toArray(new Resource[0])[0].getShortDescription().getValue());
        assertEquals("testHosted1ShortKey", testHostedResources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());

        assertEquals("testHosted2Description", testHostedResources.toArray(new Resource[0])[1].getDescription().getValue());
        assertEquals("testHosted2Key", testHostedResources.toArray(new Resource[0])[1].getDescription().getTranslationKey());
        assertEquals("testHosted2Name", testHostedResources.toArray(new Resource[0])[1].getName());
        assertEquals("testHosted2ResourceID", testHostedResources.toArray(new Resource[0])[1].getResourceID());
        assertEquals("testHosted2ResourceType", testHostedResources.toArray(new Resource[0])[1].getResourceType());
        assertEquals("testHosted2ShortDescription", testHostedResources.toArray(new Resource[0])[1].getShortDescription().getValue());
        assertEquals("testHosted2ShortKey", testHostedResources.toArray(new Resource[0])[1].getShortDescription().getTranslationKey());

        assertEquals("testHosted1Description", testClonedHostedResources.toArray(new Resource[0])[0].getDescription().getValue());
        assertEquals("testHosted1Key", testClonedHostedResources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        assertEquals("testHosted1Name", testClonedHostedResources.toArray(new Resource[0])[0].getName());
        assertEquals("testHosted1ResourceID", testClonedHostedResources.toArray(new Resource[0])[0].getResourceID());
        assertEquals("testHosted1ResourceType", testClonedHostedResources.toArray(new Resource[0])[0].getResourceType());
        assertEquals("testHosted1ShortDescription", testClonedHostedResources.toArray(new Resource[0])[0].getShortDescription().getValue());
        assertEquals("testHosted1ShortKey", testClonedHostedResources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());

        assertEquals("testHosted2Description", testClonedHostedResources.toArray(new Resource[0])[1].getDescription().getValue());
        assertEquals("testHosted2Key", testClonedHostedResources.toArray(new Resource[0])[1].getDescription().getTranslationKey());
        assertEquals("testHosted2Name", testClonedHostedResources.toArray(new Resource[0])[1].getName());
        assertEquals("testHosted2ResourceID", testClonedHostedResources.toArray(new Resource[0])[1].getResourceID());
        assertEquals("testHosted2ResourceType", testClonedHostedResources.toArray(new Resource[0])[1].getResourceType());
        assertEquals("testHosted2ShortDescription", testClonedHostedResources.toArray(new Resource[0])[1].getShortDescription().getValue());
        assertEquals("testHosted2ShortKey", testClonedHostedResources.toArray(new Resource[0])[1].getShortDescription().getTranslationKey());

        assertEquals("testHosted1Description", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "Description").getTextContent());
        assertEquals("testHosted1Key", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "Description").getAttribute("translationKey"));
        assertEquals("testHosted1Name", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "Name").getTextContent());
        assertEquals("testHosted1ResourceID", (testDataObjectHostedResources.toArray(new Element[0])[0]).getAttribute("id"));
        assertEquals("testHosted1ResourceType", (testDataObjectHostedResources.toArray(new Element[0])[0]).getAttribute("type"));
        assertEquals("testHosted1ShortDescription", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "ShortDescription").getTextContent());
        assertEquals("testHosted1ShortKey", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "ShortDescription").getAttribute("translationKey"));

        assertEquals("testHosted2Description", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[1]), "Description").getTextContent());
        assertEquals("testHosted2Key", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[1]), "Description").getAttribute("translationKey"));
        assertEquals("testHosted2Name", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[1]), "Name").getTextContent());
        assertEquals("testHosted2ResourceID", (testDataObjectHostedResources.toArray(new Element[0])[1]).getAttribute("id"));
        assertEquals("testHosted2ResourceType", (testDataObjectHostedResources.toArray(new Element[0])[1]).getAttribute("type"));
        assertEquals("testHosted2ShortDescription", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[1]), "ShortDescription").getTextContent());
        assertEquals("testHosted2ShortKey", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[1]), "ShortDescription").getAttribute("translationKey"));
        
        Collection<Resource> testHosted1Resources = testHostedResources.toArray(new Resource[0])[0].getHostedResources();
        Collection<Resource> testClonedHosted1Resources = testClonedHostedResources.toArray(new Resource[0])[0].getHostedResources();
        Collection<Element> testDataObjectHosted1Resources = session.getChildren((testDataObjectHostedResources.toArray(new Element[0])[0]), "HostedResource");

        assertEquals(1, testHosted1Resources.size());
        assertEquals(1, testClonedHosted1Resources.size());
        assertEquals(1, testDataObjectHosted1Resources.size());

        assertEquals("testHosted3Description", testHosted1Resources.toArray(new Resource[0])[0].getDescription().getValue());
        assertEquals("testHosted3Key", testHosted1Resources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        assertEquals("testHosted3Name", testHosted1Resources.toArray(new Resource[0])[0].getName());
        assertEquals("testHosted3ResourceID", testHosted1Resources.toArray(new Resource[0])[0].getResourceID());
        assertEquals("testHosted3ResourceType", testHosted1Resources.toArray(new Resource[0])[0].getResourceType());
        assertEquals("testHosted3ShortDescription", testHosted1Resources.toArray(new Resource[0])[0].getShortDescription().getValue());
        assertEquals("testHosted3ShortKey", testHosted1Resources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());

        assertEquals("testHosted3Description", testClonedHosted1Resources.toArray(new Resource[0])[0].getDescription().getValue());
        assertEquals("testHosted3Key", testClonedHosted1Resources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        assertEquals("testHosted3Name", testClonedHosted1Resources.toArray(new Resource[0])[0].getName());
        assertEquals("testHosted3ResourceID", testClonedHosted1Resources.toArray(new Resource[0])[0].getResourceID());
        assertEquals("testHosted3ResourceType", testClonedHosted1Resources.toArray(new Resource[0])[0].getResourceType());
        assertEquals("testHosted3ShortDescription", testClonedHosted1Resources.toArray(new Resource[0])[0].getShortDescription().getValue());
        assertEquals("testHosted3ShortKey", testClonedHosted1Resources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());

        assertEquals("testHosted3Description", session.getChild((testDataObjectHosted1Resources.toArray(new Element[0])[0]), "Description").getTextContent());
        assertEquals("testHosted3Key", session.getChild((testDataObjectHosted1Resources.toArray(new Element[0])[0]), "Description").getAttribute("translationKey"));
        assertEquals("testHosted3Name", session.getChild((testDataObjectHosted1Resources.toArray(new Element[0])[0]), "Name").getTextContent());
        assertEquals("testHosted3ResourceID", (testDataObjectHosted1Resources.toArray(new Element[0])[0]).getAttribute("id"));
        assertEquals("testHosted3ResourceType", (testDataObjectHosted1Resources.toArray(new Element[0])[0]).getAttribute("type"));
        assertEquals("testHosted3ShortDescription", session.getChild((testDataObjectHosted1Resources.toArray(new Element[0])[0]), "ShortDescription").getTextContent());
        assertEquals("testHosted3ShortKey", session.getChild((testDataObjectHosted1Resources.toArray(new Element[0])[0]), "ShortDescription").getAttribute("translationKey"));
    }
    
    public void testGetDescription() {
        assertEquals("testDescription", resource.getDescription().getValue());
        assertEquals("testKey", resource.getDescription().getTranslationKey());

        assertEquals("testDescription", clonedResource.getDescription().getValue());
        assertEquals("testKey", clonedResource.getDescription().getTranslationKey());
        
        Element descElement = session.getChildren(element, "Description").toArray(new Element[0])[0];
        
        assertEquals("testDescription", descElement.getTextContent());
        assertEquals("testKey", descElement.getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        assertEquals("testShortDescription", resource.getShortDescription().getValue());
        assertEquals("testShortKey", resource.getShortDescription().getTranslationKey());

        assertEquals("testShortDescription", clonedResource.getShortDescription().getValue());
        assertEquals("testShortKey", clonedResource.getShortDescription().getTranslationKey());
        
        Element descElement = session.getChildren(element, "ShortDescription").toArray(new Element[0])[0];
        
        assertEquals("testShortDescription", descElement.getTextContent());
        assertEquals("testShortKey", descElement.getAttribute("translationKey"));
    }

    public void testGetTranslatableStrings() {
        Properties props = resource.getTranslatableStrings();
        Properties clonedProps = clonedResource.getTranslatableStrings();
        
        assertEquals(8, props.keySet().size());
        assertEquals(8, clonedProps.keySet().size());
        
        assertEquals("testDescription", props.get("testKey"));
        assertEquals("testShortDescription", props.get("testShortKey"));
        assertEquals("testHosted1Description", props.get("testHosted1Key"));
        assertEquals("testHosted1ShortDescription", props.get("testHosted1ShortKey"));
        assertEquals("testHosted2Description", props.get("testHosted2Key"));
        assertEquals("testHosted2ShortDescription", props.get("testHosted2ShortKey"));
        assertEquals("testHosted3Description", props.get("testHosted3Key"));
        assertEquals("testHosted3ShortDescription", props.get("testHosted3ShortKey"));

        assertEquals("testDescription", clonedProps.get("testKey"));
        assertEquals("testShortDescription", clonedProps.get("testShortKey"));
        assertEquals("testHosted1Description", clonedProps.get("testHosted1Key"));
        assertEquals("testHosted1ShortDescription", clonedProps.get("testHosted1ShortKey"));
        assertEquals("testHosted2Description", clonedProps.get("testHosted2Key"));
        assertEquals("testHosted2ShortDescription", clonedProps.get("testHosted2ShortKey"));
        assertEquals("testHosted3Description", clonedProps.get("testHosted3Key"));
        assertEquals("testHosted3ShortDescription", clonedProps.get("testHosted3ShortKey"));
    }

    public void testSetHostedResources() {
        Resource hostedResource = SPISession.DEFAULT_INSTANCE.createBaseFactory().createHostedResource("testDifferentHostedResourceID", "testDifferentHostedResourceType");
        hostedResource.setDescription(new TranslatableString("testDifferentHostedDescription", "testDifferentHostedKey"));
        hostedResource.setName("testDifferentHostedName");
        hostedResource.setShortDescription(new TranslatableString("testDifferentHostedShortDescription", "testDifferentHostedShortKey"));
        
        resource.setHostedResources(Arrays.asList(hostedResource));
        
        Collection<Resource> testHostedResources = resource.getHostedResources();
        Collection<Resource> testClonedHostedResources = ((Resource) resource.clone()).getHostedResources();
        Collection<Element> testDataObjectHostedResources = session.getChildren(((SPIDataObject)resource).getElement(), "HostedResource");
        
        assertEquals(1, testHostedResources.size());
        assertEquals(1, testClonedHostedResources.size());
        assertEquals(1, testDataObjectHostedResources.size());
        
        assertEquals("testDifferentHostedDescription", testHostedResources.toArray(new Resource[0])[0].getDescription().getValue());
        assertEquals("testDifferentHostedKey", testHostedResources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        assertEquals("testDifferentHostedName", testHostedResources.toArray(new Resource[0])[0].getName());
        assertEquals("testDifferentHostedResourceID", testHostedResources.toArray(new Resource[0])[0].getResourceID());
        assertEquals("testDifferentHostedResourceType", testHostedResources.toArray(new Resource[0])[0].getResourceType());
        assertEquals("testDifferentHostedShortDescription", testHostedResources.toArray(new Resource[0])[0].getShortDescription().getValue());
        assertEquals("testDifferentHostedShortKey", testHostedResources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());
        
        assertEquals("testDifferentHostedDescription", testClonedHostedResources.toArray(new Resource[0])[0].getDescription().getValue());
        assertEquals("testDifferentHostedKey", testClonedHostedResources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        assertEquals("testDifferentHostedName", testClonedHostedResources.toArray(new Resource[0])[0].getName());
        assertEquals("testDifferentHostedResourceID", testClonedHostedResources.toArray(new Resource[0])[0].getResourceID());
        assertEquals("testDifferentHostedResourceType", testClonedHostedResources.toArray(new Resource[0])[0].getResourceType());
        assertEquals("testDifferentHostedShortDescription", testClonedHostedResources.toArray(new Resource[0])[0].getShortDescription().getValue());
        assertEquals("testDifferentHostedShortKey", testClonedHostedResources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());
        
        assertEquals("testDifferentHostedDescription", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "Description").getTextContent());
        assertEquals("testDifferentHostedKey", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "Description").getAttribute("translationKey"));
        assertEquals("testDifferentHostedName", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "Name").getTextContent());
        assertEquals("testDifferentHostedResourceID", (testDataObjectHostedResources.toArray(new Element[0])[0]).getAttribute("id"));
        assertEquals("testDifferentHostedResourceType", (testDataObjectHostedResources.toArray(new Element[0])[0]).getAttribute("type"));
        assertEquals("testDifferentHostedShortDescription", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "ShortDescription").getTextContent());
        assertEquals("testDifferentHostedShortKey", session.getChild((testDataObjectHostedResources.toArray(new Element[0])[0]), "ShortDescription").getAttribute("translationKey"));
    }

    public void testSetName() {
        resource.setName("testSetName");
        
        assertEquals("testSetName", resource.getName());
        assertEquals("testSetName", session.getChild(((SPIDataObject)resource).getElement(), "Name").getTextContent());
    }

    public void testSetResourceID() {
        resource.setResourceID("testSetResourceID");
        
        assertEquals("testSetResourceID", resource.getResourceID());
        assertEquals("testSetResourceID", ((SPIDataObject)resource).getElement().getAttribute("id"));
        
        try {
            resource.setResourceID(null);
            fail("Null value was set for id");
        }
        catch(Exception e) {
        }
    }

    public void testSetResourceType() {
        resource.setResourceType("testSetResourceType");
        
        assertEquals("testSetResourceType", resource.getResourceType());
        assertEquals("testSetResourceType", ((SPIDataObject)resource).getElement().getAttribute("type"));
        
        try {
            resource.setResourceType(null);
            fail("Null value was set for type");
        }
        catch(Exception e) {
        }
    }

    public void testSetProperties() {
        Properties properties = new Properties();
        properties.setProperty("testSetPropertiesKey", "testSetPropertiesValue");
        resource.setProperties(properties);
        
        Properties testProps = resource.getProperties();
        Collection<Element> testDataObjectProps = session.getChildren(element, "Property");;
        
        assertEquals("testSetPropertiesValue", testProps.get("testSetPropertiesKey"));
        
        assertEquals(1, testDataObjectProps.size());
        
        for (int i = 0; i < testDataObjectProps.size(); i++) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            
            String value = session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            
            assertTrue(value + " wasn't found in the properties object", testProps.contains(value));
            assertTrue(propertyName + " wasn't found in the properties object", testProps.containsKey(propertyName));
            assertEquals(value, testProps.get(propertyName));
        }
    }

    public void testSetDescription() {
        resource.setDescription(new TranslatableString("testSetDescription", "testSetDescriptionKey"));
        
        assertEquals("testSetDescription", resource.getDescription().getValue());
        assertEquals("testSetDescription", session.getChild(((SPIDataObject)resource).getElement(), "Description").getTextContent());
        assertEquals("testSetDescriptionKey", resource.getDescription().getTranslationKey());
        assertEquals("testSetDescriptionKey", session.getChild(((SPIDataObject)resource).getElement(), "Description").getAttribute("translationKey"));
    }

    public void testSetShortDescription()
    {
        resource.setShortDescription(new TranslatableString("testSetShortDescription", "testSetShortDescriptionKey"));
        
        assertEquals("testSetShortDescription", resource.getShortDescription().getValue());
        assertEquals("testSetShortDescription", session.getChild(((SPIDataObject)resource).getElement(), "ShortDescription").getTextContent());
        assertEquals("testSetShortDescriptionKey", resource.getShortDescription().getTranslationKey());
        assertEquals("testSetShortDescriptionKey", session.getChild(((SPIDataObject)resource).getElement(), "ShortDescription").getAttribute("translationKey"));
    }
}
