/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Describable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyValueList;

/**
 * ConditionalPropertyConstraintType provides the type definition for a PropertyConstraint included within Alternatives specified in 
 * Condition elements. The ConditionalPropertyConstraintType is very similar to the PropertyConstraintType; the only difference is 
 * that the Value element defined in the ConditionalPropertyConstraintType is of type xsd:string which is less restrictive than the 
 * Value element defined in the PropertyConstraintType which is of VariableExpressionType. 
 */
public interface ConditionalPropertyConstraint extends Describable {
	
	/**
	 * Gets the property name.
	 * 
	 * The property name can be used to find the property value in the deployment environment. The name may be defined in a profile. 
	 * 
	 * @return Name of the constrained property.
	 */
	String getPropertyName();
	
	/**
	 * Sets the property name.
	 * 
	 * The property name can be used to find the property value in the deployment environment. The name may be defined in a profile.
	 * 
	 * @param propertyName Name of the constrained property.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setPropertyName(String propertyName);
	
	/**
	 * Gets the PropertyValueList.
	 * 
	 * A list of required values can be defined in place of a single required value. 
	 * 
	 * @return List of required property values.
	 */
	PropertyValueList getValueList();
	
	/**
	 * Sets the PropertyValueList.
	 * 
	 * A list of required values can be defined in place of a single required value. 
	 *  
	 * @param values List of required property values.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setValueList(PropertyValueList values);
	
	/**
	 * Gets the value.
	 * 
	 * In a condition, the value used in a property constraint is a string rather than a variable expression. 
	 * 
	 * @return Required property value.
	 */
	String getValue();
	
	/**
	 * Sets the value.
	 * 
	 * In a condition, the value used in a property constraint is a string rather than a variable expression. 
	 * 
	 * @param value Required property value.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setValue(String value);

	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
