/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable;

/**
 * BoundaryType defines upper and lower bounds that can be used to validate the input received for that parameter.
 */
public interface ParameterBoundary {
    /**
     * Gets the lower bound.
     * 
     * This variable expression MUST resolve to an integer.<br><br>
     * If no LowerBound is specified, no integer value is too low.<br><br>
     * A LowerBound of 0 restricts the integer parameter to positive integer values.
     * 
     * @return Lowest valid value for the parameter.
     */
    Integer getLowerBound();
    
    /**
     * Gets the upper bound.
     * 
     * This variable expression MUST resolve to an integer.<br><br>
     * If no UpperBound is specified, no integer value is too high.
     * 
     * @return Highest valid value for the parameter.
     */
    Integer getUpperBound();
    
    /**
     * Sets the lower bound.
     * 
     * This variable expression MUST resolve to an integer.<br><br>
     * If no LowerBound is specified, no integer value is too low.<br><br>
     * A LowerBound of 0 restricts the integer parameter to positive integer values.
     * 
     * @param lowerBound Lowest valid value for the parameter.
     */
    void setLowerBound(Integer lowerBound);
    
    /**
     * Sets the upper bound.
     * 
     * This variable expression MUST resolve to an integer.<br><br>
     * If no UpperBound is specified, no integer value is too high.
     * 
     * @param upperBound Highest valid value for the parameter.
     */
    void setUpperBound(Integer upperBound);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    Object clone();
}
