/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * CanonicalizationMethod is a required element that specifies the canonicalization 
 * algorithm applied to the SignedInfo element prior to performing signature calculations.
 * 
 *
 */
public interface CanonicalizationMethod {
	/**
	 * Gets the algorithm.
	 * 
	 * @return The algorithm.
	 */
	String getAlgorithm();
	
	/**
	 * Sets the algorithm.
	 * 
	 * @param algorithm The new algorithm.
	 */
	void setAlgorithm(String algorithm);
}
