/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.Parameter;

public class BaseParameterType {
	

	public static boolean equals( Parameter baseParameter1, Parameter baseParameter2){
		
		//compare sensitive and required booleans
		if(baseParameter1.isRequired() != baseParameter2.isRequired()){
			return false;
		}
		
		if(baseParameter1.isSensitive() != baseParameter2.isSensitive()){
			return false;
		}
		
		//compare default value and all operations
		if(!VariableExpressionType.equals(baseParameter1.getDefaultValue(),baseParameter2.getDefaultValue())){
			return false;
		}
		
		Collection<String> operations1 = new ArrayList<String>();
		Collection<String> operations2 = new ArrayList<String>();
		
		operations1 = baseParameter1.getOperations();
		operations2 = baseParameter2.getOperations();
		
		if(!operations1.containsAll(operations2) || !operations2.containsAll(operations1)){
			return false;
		}
		
		return true;
	}
}
