/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;

public class IdentityType {

	public static Identity merge(Identity identity1, Identity identity2){
		
		if( equals(identity1,identity2) ){
			/*
			   <IdentityType> 	 	 	 	
				softwareID 	xsd:string 	Yes				
				Description 		<DisplayTextType> 	Merge
				ShortDescription 		<DisplayTextType> 	Merge
				Name 		<DisplayTextType> 	Merge
				Version 		<VersionType> 	Merge
				MaintenanceInformation 		<MaintenanceInformationType> 	Merge
				BuildInformation 		<BuildInformationType> 	Merge
				Manufacturer 		<ManufacturerType> 	Merge
				 
			 */
			
			
			identity1.setDescription(TranslatableStringType.merge(identity1.getDescription(), identity2.getDescription()));
			identity1.setShortDescription(TranslatableStringType.merge(identity1.getShortDescription(), identity2.getShortDescription()));
			identity1.setName(TranslatableStringType.merge(identity1.getName(), identity2.getName()));
			//TODO: how do we merge versions?
			//identity1.setVersion(VersionType.merge(identity1.getVersion(), identity2.getVersion()));
			identity1.setMaintenanceInformation(MaintenanceInformationType.merge(identity1.getMaintenanceInformation(), identity2.getMaintenanceInformation()));
			identity1.setBuildID(StringType.merge(identity1.getBuildID(), identity2.getBuildID()));
			identity1.setManufacturerInformation(ManufacturerInformationType.merge(identity1.getManufacturerInformation(),identity2.getManufacturerInformation()));
			return identity1;
		}

		return null;
	}
	
	public static boolean equals(Identity identity1, Identity identity2){
		
		if( identity1.getSoftwareID() == "" || identity2.getSoftwareID() == "" ){
			return true;
		}
		else if(identity1.getSoftwareID().equals(identity2.getSoftwareID())){
			return true;
		}
		
		return false;
	}
}
