/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.application.impl;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoHandler
extends DefaultHandler {
    private Map<String, Map<String, String>> typeInfo;
    private Map<String, String> importStatements;
    private Map<String, String> prefixURIMap;
    private String defaultNamespace;
    private String complexElementTypeName;
    private Map<String, Map<String, String>> hierarchyInfo;
    private String elementName;
    private String elementType;

    public TypeInfoHandler(Map<String, Map<String, String>> typeInfo, Map<String, Map<String, String>> hierarchyInfo) {
        this.typeInfo = typeInfo;
        this.hierarchyInfo = hierarchyInfo;
        this.importStatements = new Hashtable<String, String>();
        this.prefixURIMap = new Hashtable<String, String>();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if ("schema".equals(localName)) {
                int i = 0;
                int attCount = attributes.getLength();
                while (i < attCount) {
                    String attLocalName = attributes.getQName(i);
                    if (attLocalName.startsWith("xmlns")) {
                        String prefix;
                        int colonInx = -1;
                        String namespaceURI = attributes.getValue(attLocalName);
                        colonInx = attLocalName.indexOf(58);
                        String string = prefix = colonInx < 0 ? null : attLocalName.substring(colonInx + 1);
                        if (namespaceURI != null) {
                            if (prefix != null) {
                                this.prefixURIMap.put(prefix, namespaceURI);
                            } else {
                                this.defaultNamespace = namespaceURI;
                            }
                        }
                    }
                    ++i;
                }
                String targetNamespace = attributes.getValue("targetNamespace");
                if (targetNamespace != null) {
                    this.defaultNamespace = targetNamespace;
                }
            } else if ("import".equals(localName)) {
                String namespace = attributes.getValue("namespace");
                String location = attributes.getValue("schemaLocation");
                if (namespace != null && location != null) {
                    this.importStatements.put(namespace, location);
                }
            } else if ("element".equals(localName)) {
                this.elementName = attributes.getValue("name");
                this.elementType = attributes.getValue("http://www.w3.org/2001/XMLSchema", "type");
                this.elementType = this.elementType == null ? attributes.getValue("type") : this.elementType;
                String[] tokenizedType = this.tokenizeType(this.elementType);
                String namespace = tokenizedType[0];
                String type = tokenizedType[1];
                if (namespace != null) {
                    Map elementTypes = SMLValidatorUtil.retrieveNestedMap(this.typeInfo, (String)this.defaultNamespace, (boolean)true);
                    if (this.elementName != null) {
                        elementTypes.put(this.elementName, String.valueOf(namespace) + ":" + type);
                    }
                }
            } else if ("complexType".equals(localName)) {
                this.complexElementTypeName = attributes.getValue("name");
            } else if ("extension".equals(localName)) {
                String[] tonizedType;
                if (this.elementName != null && this.elementType == null) {
                    Map elementTypes = SMLValidatorUtil.retrieveNestedMap(this.typeInfo, (String)this.defaultNamespace, (boolean)true);
                    this.complexElementTypeName = String.valueOf(this.elementName) + "Type";
                    elementTypes.put(this.elementName, String.valueOf(this.defaultNamespace) + ":" + this.complexElementTypeName);
                }
                if ((tonizedType = this.tokenizeType(attributes.getValue("base")))[0] != null && tonizedType[1] != null) {
                    Map typeHirarchy = SMLValidatorUtil.retrieveNestedMap(this.hierarchyInfo, (String)this.defaultNamespace, (boolean)true);
                    typeHirarchy.put(this.complexElementTypeName, String.valueOf(tonizedType[0]) + ":" + tonizedType[1]);
                }
            }
        }
    }

    public String[] tokenizeType(String type) {
        if (type == null) {
            return new String[2];
        }
        int colonInx = -1;
        colonInx = type.indexOf(58);
        String prefix = colonInx < 0 ? null : type.substring(0, colonInx);
        String namespace = prefix == null ? this.defaultNamespace : this.prefixURIMap.get(prefix);
        type = colonInx < 0 ? type : type.substring(colonInx + 1);
        return new String[]{namespace, type};
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if ("complexType".equals(localName)) {
                this.complexElementTypeName = null;
            } else if ("element".equals(localName)) {
                this.elementName = null;
                this.elementType = null;
            }
        }
    }

    public Map<String, String> getImportStatements() {
        return this.importStatements;
    }
}

