/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.IntegerParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.Parameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.StringParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.BooleanType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.IntegerParameterType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.OperationsType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringParameterType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterGroupType {
    static ParameterGroup merge(Collection<ParameterGroup> collection1, Collection<ParameterGroup> collection2) {
        HashSet<ParameterGroup> mergedSet = new HashSet<ParameterGroup>();
        mergedSet.addAll(collection1);
        mergedSet.addAll(collection2);
        ParameterGroup merged = null;
        HashSet boolParms = new HashSet();
        HashSet intParms = new HashSet();
        HashSet strParms = new HashSet();
        HashSet uriParms = new HashSet();
        for (ParameterGroup group : mergedSet) {
            if (merged == null) {
                merged = (ParameterGroup)group.clone();
            }
            ParameterGroupType.merge(group.getBooleanParameters(), boolParms);
            ParameterGroupType.merge(group.getIntegerParameters(), intParms);
            ParameterGroupType.merge(group.getStringParameters(), strParms);
            ParameterGroupType.merge(group.getURIParameters(), uriParms);
        }
        if (merged != null) {
            merged.setBooleanParameters(boolParms);
            merged.setIntegerParameters(intParms);
            merged.setStringParameters(strParms);
            merged.setURIParameters(uriParms);
        }
        return merged;
    }

    private static <T extends Parameter> void merge(Collection<T> newParms, Set<T> mergedParms) {
        Iterator<T> i = newParms.iterator();
        while (i.hasNext()) {
            boolean matches = false;
            Parameter newParm = (Parameter)i.next();
            for (Parameter mergedParm : mergedParms) {
                if (!ParameterGroupType.equals(newParm, mergedParm)) continue;
                matches = true;
                if (newParm instanceof StringParameter) {
                    StringParameterType.merge((StringParameter)newParm, (StringParameter)mergedParm);
                    break;
                }
                ParameterGroupType.merge(newParm, mergedParm);
                break;
            }
            if (matches) continue;
            mergedParms.add(newParm);
        }
    }

    private static boolean equals(Parameter p1, Parameter p2) {
        boolean equals = true;
        equals = equals && StringType.equals(p1.getDefaultValue(), p2.getDefaultValue());
        equals = equals && BooleanType.equals(p1.isSensitive(), p2.isSensitive());
        equals = equals && BooleanType.equals(p1.isRequired(), p2.isRequired());
        boolean bl = equals = equals && OperationsType.equals(p1.getOperations(), p2.getOperations());
        if (equals && p1 instanceof IntegerParameter) {
            equals = IntegerParameterType.equals((IntegerParameter)p1, (IntegerParameter)p2);
        }
        return equals;
    }

    static Parameter merge(Parameter newParm, Parameter merged) {
        merged.setDisplayName(TranslatableStringType.merge(newParm.getDisplayName(), merged.getDisplayName()));
        merged.setDescription(TranslatableStringType.merge(newParm.getDescription(), merged.getDescription()));
        merged.setShortDescription(TranslatableStringType.merge(newParm.getShortDescription(), merged.getShortDescription()));
        return merged;
    }
}

