/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.OutputVariable;
import org.w3c.dom.Element;

public class OutputVariable_Test
extends TestCase {
    OutputVariable var;
    OutputVariable clonedVar;
    Element element;
    SPISessionImpl session;

    public OutputVariable_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.var = SPISession.DEFAULT_INSTANCE.createVariableFactory().createOutputVariable("varID");
        this.var.setDescription(new TranslatableString("desc", "descKey"));
        this.var.setShortDescription(new TranslatableString("shortDesc", "shortDescKey"));
        this.var.setOutputParameterName("paramName");
        this.var.setSensitive(Boolean.TRUE);
        this.clonedVar = (OutputVariable)this.var.clone();
        this.element = ((SPIDataObject)((Object)this.var)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = this.var.getTranslatableStrings();
        Properties clonedProps = this.clonedVar.getTranslatableStrings();
        OutputVariable_Test.assertEquals((int)2, (int)props.keySet().size());
        OutputVariable_Test.assertEquals((int)2, (int)clonedProps.keySet().size());
        OutputVariable_Test.assertEquals((Object)"desc", (Object)props.get("descKey"));
        OutputVariable_Test.assertEquals((Object)"shortDesc", (Object)props.get("shortDescKey"));
        OutputVariable_Test.assertEquals((Object)"desc", (Object)clonedProps.get("descKey"));
        OutputVariable_Test.assertEquals((Object)"shortDesc", (Object)clonedProps.get("shortDescKey"));
    }

    public void testGetOutputParameterName() {
        OutputVariable_Test.assertEquals((String)"paramName", (String)this.var.getOutputParameterName());
        OutputVariable_Test.assertEquals((String)"paramName", (String)this.clonedVar.getOutputParameterName());
        OutputVariable_Test.assertEquals((String)"paramName", (String)this.element.getAttribute("outputParameterName"));
    }

    public void testGetVariableID() {
        OutputVariable_Test.assertEquals((String)"varID", (String)this.var.getVariableID());
        OutputVariable_Test.assertEquals((String)"varID", (String)this.clonedVar.getVariableID());
        OutputVariable_Test.assertEquals((String)"varID", (String)this.element.getAttribute("id"));
    }

    public void testIsSensitive() {
        OutputVariable_Test.assertTrue((boolean)this.var.isSensitive());
        OutputVariable_Test.assertTrue((boolean)this.clonedVar.isSensitive());
        OutputVariable_Test.assertTrue((boolean)Boolean.parseBoolean(this.element.getAttribute("sensitive")));
    }

    public void testGetDescription() {
        OutputVariable_Test.assertEquals((String)"desc", (String)this.var.getDescription().getValue());
        OutputVariable_Test.assertEquals((String)"descKey", (String)this.var.getDescription().getTranslationKey());
        OutputVariable_Test.assertEquals((String)"desc", (String)this.clonedVar.getDescription().getValue());
        OutputVariable_Test.assertEquals((String)"descKey", (String)this.clonedVar.getDescription().getTranslationKey());
        OutputVariable_Test.assertEquals((String)"desc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        OutputVariable_Test.assertEquals((String)"descKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        OutputVariable_Test.assertEquals((String)"shortDesc", (String)this.var.getShortDescription().getValue());
        OutputVariable_Test.assertEquals((String)"shortDescKey", (String)this.var.getShortDescription().getTranslationKey());
        OutputVariable_Test.assertEquals((String)"shortDesc", (String)this.clonedVar.getShortDescription().getValue());
        OutputVariable_Test.assertEquals((String)"shortDescKey", (String)this.clonedVar.getShortDescription().getTranslationKey());
        OutputVariable_Test.assertEquals((String)"shortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        OutputVariable_Test.assertEquals((String)"shortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetOutputParameterName() {
        this.var.setOutputParameterName("differentName");
        OutputVariable_Test.assertEquals((String)"differentName", (String)this.var.getOutputParameterName());
        OutputVariable_Test.assertEquals((String)"differentName", (String)this.element.getAttribute("outputParameterName"));
    }

    public void testSetSensitive() {
        this.var.setSensitive(Boolean.FALSE);
        OutputVariable_Test.assertFalse((boolean)this.var.isSensitive());
        OutputVariable_Test.assertFalse((boolean)Boolean.parseBoolean(this.element.getAttribute("sensitive")));
    }

    public void testSetVariableID() {
        this.var.setVariableID("differentID");
        OutputVariable_Test.assertEquals((String)"differentID", (String)this.var.getVariableID());
        OutputVariable_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("id"));
        try {
            this.var.setVariableID(null);
            OutputVariable_Test.fail((String)"ID was set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetDescription() {
        this.var.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        OutputVariable_Test.assertEquals((String)"differentDesc", (String)this.var.getDescription().getValue());
        OutputVariable_Test.assertEquals((String)"differentDescKey", (String)this.var.getDescription().getTranslationKey());
        OutputVariable_Test.assertEquals((String)"differentDesc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        OutputVariable_Test.assertEquals((String)"differentDescKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.var.setShortDescription(new TranslatableString("differentShortDesc", "differentShortDescKey"));
        OutputVariable_Test.assertEquals((String)"differentShortDesc", (String)this.var.getShortDescription().getValue());
        OutputVariable_Test.assertEquals((String)"differentShortDescKey", (String)this.var.getShortDescription().getTranslationKey());
        OutputVariable_Test.assertEquals((String)"differentShortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        OutputVariable_Test.assertEquals((String)"differentShortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }
}

