/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyValueList;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;



public class PropertyValueListType {

	
	
	public static boolean equals(PropertyValueList list1, PropertyValueList list2)
	{		
		boolean equals = true;
		
		Collection<String> values1 = list1.getValue();
		Collection<String> values2 = list2.getValue();
		
		Iterator<String> valueIter1 = values1.iterator();	
		
		while ((valueIter1.hasNext())&&(equals))
		{
			String value1 = valueIter1.next();
			
			Iterator<String> valueIter2 = values2.iterator();
			while (valueIter2.hasNext())
			{
				String value2 = valueIter2.next();
				if ((value1.equals(value2))==false)				   
				{
					equals=false;
				}
				
			}
		}
		
		if (equals)
		{
			equals = list1.getMatch().equals(list2.getMatch());
		}
		
		return equals;
		
	}
}

