/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingResourceMap;

public class StringType
{
	public static boolean equals(String s1, String s2)
	{
		if(s1 != null) {
			return s1.equals(s2);
		}
		else {
			return s2 == null;
		}
	}
	public static String merge(String s1, String s2)
	{
		if ((s1==null)&&(s2!=null))
			return s2;
		if ((s1!=null)&&(s2==null))
			return s1;
		if ((s1==null)&&(s2==null))
			return null;
		
		return s1.concat(s2);
	}
	public static Collection <String> merge(Collection <String> strings1, Collection <String> strings2)
	{
		// set to hold all the merged variables
		Collection <String> stringsToRemove = new ArrayList <String> ();
		Iterator <String> stringIter1 = strings1.iterator();		
		//iterate through the strings
		while (stringIter1.hasNext())
		{
			String string1 = (String) stringIter1.next();
			Iterator <String> stringIter2 = strings2.iterator();
			while (stringIter2.hasNext())
			{
				String string2 = (String) stringIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (stringsToRemove.contains(string2)==false)
				{
					if (equals(string1, string2))
					{  //merge hosted strings, types and description strings
						stringsToRemove.add(string2);						
						string1 = merge(string1,string2);						
					}
				}
					
			}
		}
		
		strings2.removeAll(stringsToRemove);
		//remove all of the matches that were found
		
		Collection <String> finalStrings = new ArrayList <String> ();
		//create and return a new collection with all of the remaining items
		finalStrings.addAll(strings1);
		finalStrings.addAll(strings2);		
		
		return finalStrings;
		
	}
}
