/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ManufacturerInformation;
import org.w3c.dom.Element;

/**
 * From the SDD Spec - "This complex type provides identity information for a
 * manufactured entity. The package as a whole, as well as package subsets
 * represented by the content elements defined in the deployment descriptor,
 * can have an identity expressed with an element of IdentityType."
 *
 */
public class IdentityImpl extends NameableObject implements Identity, Cloneable {
	private static final String IDENTITY_TYPE = "sdd-common:IdentityType";

	public IdentityImpl(Element data, SPISessionImpl session) {
		super(data, session, IDENTITY_TYPE);
	}
	
	public IdentityImpl(Element data, SPISessionImpl session, String sddSchemaType) {
		super(data, session, sddSchemaType);
	}

	
	public String getBuildID() {
		String buildID = null;
		
		if (isSetElement("BuildInformation")) {
			String buildAttribute = getChild("BuildInformation").getAttribute("buildID");
			if (buildAttribute != null && buildAttribute.length() > 0) {
				buildID = buildAttribute;	
			}
		}
				
		return buildID;
	}
	
	public ManufacturerInformation getManufacturerInformation() {
		ManufacturerInformation information = null;

		if (isSetElement("Manufacturer")) {
	        Element manu = getChild("Manufacturer");
	        information = new ManufacturerInformationImpl(manu, session);
		}
		
		return information;
	}
//	
//	public <T> T getElement(Element parent, Class<T> c)
//	{
//        T element = null;
//
//        String name = null;
//        
//        try
//        {
//            Field f = c.getDeclaredField("NODE_NAME");
//            name = (String) f.get(null);
//        }
//        catch (SecurityException e1)
//        {
//            // TODO Auto-generated catch block
//            e1.printStackTrace();
//        }
//        catch (NoSuchFieldException e1)
//        {
//            // TODO Auto-generated catch block
//            e1.printStackTrace();
//        }
//        catch (IllegalArgumentException e)
//        {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
//        catch (IllegalAccessException e)
//        {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
//        
//        Collection<Element> list = session.getChildren(parent, name);
//        
//        if (!list.isEmpty())
//        {
//            element = null;
//        }
//        else if (list.size() == 1)
//        {
//            try
//            {
//                Element copy = (Element) list.iterator().next().cloneNode(true);
//                Constructor<T> constructor = c.getConstructor(Element.class, SPISession.class);
//                element = constructor.newInstance(copy, session);
//            }
//            catch (IllegalAccessException e)
//            {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
//            catch (InstantiationException e)
//            {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
//            catch (SecurityException e)
//            {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
//            catch (NoSuchMethodException e)
//            {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
//            catch (IllegalArgumentException e)
//            {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
//            catch (InvocationTargetException e)
//            {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
//        }
//        else if (list.getLength() > 1)
//        {
//            //TODO: throw exception
//        }
//        else
//        {
//            //TODO: throw exception
//        }
//        
//        return element;
//	}
//	
//	public void setElement(Element parent, Element child)
//	{
//	    
//	}
	
	public String getVersion() {
	    String value = null;
	    
	    if (isSetElement("version")) {
	        value = getChild("version").getTextContent();
	    }
	    
		return value;
	}

	public String getSoftwareID() {
        String value = null;
        
        if (isSetAttribute("softwareID")) {
        	value = getAttribute("softwareID");
        }
        
        return value;
	}

	public void setBuildID(String buildID) {
		if (buildID != null) {
			if (!isSetElement("BuildInformation")) {
				Element buildInfo = session.createCommonElement("BuildInformation");
				setContent(buildInfo);
			}
			
			Element buildInfo = getChild("BuildInformation");
			buildInfo.setAttribute("buildID", buildID);
			
			setContent(buildInfo);
		}
		else {
			unSetElement("BuildInformation");
		}
	}
	
	public MaintenanceInformation getMaintenanceInformation() {
	    MaintenanceInformation information = null;
	    
	    if (isSetElement("MaintenanceInformation")) {
	    	Element element = getChild("MaintenanceInformation");
	    	information = new MaintenanceInformationImpl(element, session);
	    }
	    
	    return information;
	}
	
	public void setManufacturerInformation(ManufacturerInformation information) {
		if (information == null) {
			unSetElement("Manufacturer");
		}
		else {
			setContent((SPIDataObject)information);
		}
	}

	public void setVersion(String version) {
		// TODO error-check input
		if (version == null) {
			unSetElement("Version");
		}
		else {
			Element versionElement = session.createCommonElement("Version");
			versionElement.setTextContent(version);
			
			setContent(versionElement);
		}
	}
	
	public void setSoftwareID(String softwareID) {
		// TODO error-check input
		setAttribute("softwareID", softwareID);
	}
	
	public void setMaintenanceInformation(MaintenanceInformation information) {
        if (information == null) {
        	unSetElement("MaintenanceInformation");
        }
        else {
        	setContent((SPIDataObject)information);
        }
	}

	public Object clone() {
		return new IdentityImpl((Element)getElement().cloneNode(true), session);
	}
	
	public String toString() {
		String description = super.toString();
		
		description += "SoftwareID: " + getSoftwareID() + "\n";
		description += "Version: " + getVersion() + "\n";
		description += "BuildID: " + getBuildID() + "\n";
		
		return description;
	}	
}
