/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DisplayNameable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Nameable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public abstract class NameableObject extends DescribableObject implements Nameable, DisplayNameable {
	
	public NameableObject(Element data, SPISessionImpl session, String sddSchemaType) {
		super(data, session, sddSchemaType);
	}
	
	public TranslatableString getName() {
		TranslatableString ts = null;
		
		if (isSetElement("Name")) {
			Element nameElement = getChild("Name");
			ts = new TranslatableString(nameElement);
		}

		return ts;
	}

	public TranslatableString getDisplayName() {
		TranslatableString ts = null;
		
		if (isSetElement("DisplayName")) {
			Element nameElement = getChild("DisplayName");
			ts = new TranslatableString(nameElement);
		}

		return ts;
	}
	
	public void setName(TranslatableString name) {
		if (name == null) {
			unSetElement("Name");
		}
		else 
		{
			Element element = session.createCommonElement("Name");
			element.setTextContent(name.getValue());
			element.setAttribute("translationKey", name.getTranslationKey());
			setContent(element);
		}
	}
	
	public void setDisplayName(TranslatableString displayName) {
		if (displayName == null){
			unSetElement("DisplayName");
		}
		else {
			Element element = session.createCommonElement("DisplayName");
            element.setTextContent(displayName.getValue());
            element.setAttribute("translationKey", displayName.getTranslationKey());

			setContent(element);
		}
	}

	public String toString() {
		String tmp = new String();
		
		if (isSetElement("Name")){
			tmp += "Name - " + getChild("Name").getTextContent() + "\n";
		}
		else {
			tmp = "Name - (Not set)\n";
		}
		
		if (isSetElement("DisplayName")) {
			tmp += "DisplayName - " + getChild("DisplayName").getTextContent() + "\n";
		}
		else {
			tmp += "DisplayName - (not set)\n";
		}

		return tmp + super.toString();
	}
}
