/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import java.util.Collection;

/**
 * The software package described by the SDD can be identified for humans and package management software using the properties in 
 * PackageIdentity. The PackageIdentity is not to be confused with the identity of the deployed software, which is described in the 
 * resulting resource elements of the deployment descriptor.
 */
public interface PackageIdentity extends Identity, Cloneable {
	

    /**
     * Gets the Package Types.
     * 
     * The package type is provided to aid consumer understanding of the type of content contained in the package. A package can 
     * contain more than one type of content. In this case, a single packageType value should be selected that represents the primary 
     * content type as determined by the SDD author. The SDD defines a set of enumeration values in PackageTypeType which are 
     * extendable by the SDD author.<br><br>
     * The enumerated types defined by the SDD are as follows:
     * <li>baseInstall</li>
     * <li>baseUninstall</li>
     * <li>configuration</li>
     * <li>maintenance</li>
     * <li>modification</li>
     * <li>replacement</li>
     * <li>localization</li><br><br>
     * 
     * @return A collection of types of the package.
     */
    Collection<String> getPackageTypes();
	
	/**
	 * Gets the Content Type.
	 * 
	 * The value of contentType is determined by the SDD manufacturer to communicate a characteristic of the package that MAY be 
	 * used in the manufacturers package management system or other manufacturer-specific tools that use the SDD. The SDD author 
	 * chooses the values; they are not defined in this specification.
	 * 
	 * @return The type of content provided by this package, for example, BIOS.
	 */
	String getContentType();
	
	/**
	 * Gets the label.
	 * 
	 * The label MAY be used as an index in a package management system. The SDD author chooses the values; they are not defined 
	 * in this specification.
	 * 
	 * @return A label for this package.
	 */
	String getLabel();
	
	
	/**
	 * Sets the content type.
	 * 
	 * The value of contentType is determined by the SDD manufacturer to communicate a characteristic of the package that MAY be 
	 * used in the manufacturers package management system or other manufacturer-specific tools that use the SDD. The SDD author 
	 * chooses the values; they are not defined in this specification.
	 * 
	 * @param contentType The type of content provided by this package, for example, BIOS.
	 */
	void setContentType(String contentType);
	
	/**
	 * Sets the label.
	 * 
	 * The label MAY be used as an index in a package management system. The SDD author chooses the values; they are not defined 
	 * in this specification.
	 * 
	 * @param label A label for this package.
	 */
	void setLabel(String label);

	/**
	 * Sets the package types.
	 * 
	 * The package type is provided to aid consumer understanding of the type of content contained in the package. A package can 
     * contain more than one type of content. In this case, a single packageType value should be selected that represents the primary 
     * content type as determined by the SDD author. The SDD defines a set of enumeration values in PackageTypeType which are 
     * extendable by the SDD author.<br><br>
     * The enumerated types defined by the SDD are as follows:
     * <li>baseInstall</li>
     * <li>baseUninstall</li>
     * <li>configuration</li>
     * <li>maintenance</li>
     * <li>modification</li>
     * <li>replacement</li>
     * <li>localization</li><br><br>
     * 
	 * @param packageType Types of the package.
	 */
	void setPackageTypes(Collection<String> packageType);
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	public Object clone();
}
