/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
/**
 * 
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg;
 
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.BTGApplication;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.ValidationFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.XML_DAS;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.w3c.dom.Document;


/**
 * 
 *
 */
public class BTG_Test extends TestCase{

	//private String propertiesFile;
	//private PropertiesReader propsReader;
	//private Collection<Properties> props;
	private BTGApplication btgApp;
	//private static final String OUTPUT_FILEBASE_PROPERTY = "OutputFileNameBase";
	private String fileNameBase;
	private String resultingResourceName;
	/**
	 * @param name
	 */
	public BTG_Test(String name) {
		super(name);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		
		fileNameBase = System.getProperty("java.io.tmpdir")+ File.separator +"BTGTEST";
		
		//propertiesFile = AllTests.VALID_PROP;
		// Read in the list of properties from properties file
		//propsReader = new PropertiesReader(propertiesFile);
		//props = propsReader.getPropertiesList();
		btgApp = new BTGApplication();
		
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public Document getSDDData(String file) throws FileNotFoundException, IOException, XMLValidationException{
		Document xmlDocument = null;
		
		// Create an InputStream for the SDD File
		InputStream inputStream = new FileInputStream(file);
		XML_DAS myXmlDas = ValidationFactory.DEFAULT_INSTANCE.createXML_DAS();
		try {
			

			xmlDocument = myXmlDas.loadDocument(inputStream);
			
			// Create a DocumentBuilder and parse the InputStream into a Document
			//DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			//DocumentBuilder builder = factory.newDocumentBuilder();
			//xmlDocument = builder.parse(inputStream);		
			
			//xmlDocument = builder.parse(file);	
		} catch (Exception e) {
			e.printStackTrace();
			
		} finally {
			inputStream.close();
		}
		
		return xmlDocument;
	}	
	/**
	 * 
	 */
	public void testGetSupportedProperties() throws Exception {
		Collection<BTGProperty> btgp = btgApp.getSupportedProperties();
		
		assertTrue(btgp!=null);
		assertEquals(btgp.size(), 1);
		assertEquals("OutputFileNameBase", btgp.toArray(new BTGProperty[0])[0].getName());
		assertTrue(btgp.toArray(new BTGProperty[0])[0].isRequired());
	}
	
	public void testWriteSDDs_ValidDDFile() throws FileNotFoundException, XMLValidationException, IOException{
		Collection<Document> sdds = new ArrayList<Document>();
		sdds.add(getSDDData(AllTests.VALID_DDFILE));

		btgApp.writeDescriptorsToFiles(sdds, fileNameBase);

		File output = new File(fileNameBase+".dd.xml");
		
		try {
			FileInputStream f = new FileInputStream(output);
			output.delete();
		}catch (FileNotFoundException e){
			fail("Did not create expected DD file.");
		}
		
	}
	
	//Invalid SDDs will be allowed
	public void testWriteSDDs_InvalidDDFile() throws XMLValidationException, FileNotFoundException, IOException{
		
		Collection<Document> sdds = new ArrayList<Document>();
		sdds.add(getSDDData(AllTests.INVALID_DDFILE));
		btgApp.writeDescriptorsToFiles(sdds, fileNameBase);

		File output = new File(fileNameBase+".dd.xml");
		
		try {
			FileInputStream f = new FileInputStream(output);
			output.delete();
		}catch (FileNotFoundException e){
			fail("Did not create expected DD file.");
		}
		
		/*try {
			btgApp.writeDescriptorsToFiles(sdds, fileNameBase);
			fail("Invalid DD file, but no XMLValidationException was thrown");
		}catch (XMLValidationException e){
			//Expect to get this.
		}*/
		
	}
	
	public void testWriteSDDs_ValidPDFile() throws FileNotFoundException, XMLValidationException, IOException{
		Collection<Document> sdds = new ArrayList<Document>();
		sdds.add(getSDDData(AllTests.VALID_PDFILE));
		btgApp.writeDescriptorsToFiles(sdds, fileNameBase);
		
		File output = new File(fileNameBase+".pd.xml");
		
		try {
			FileInputStream f = new FileInputStream(output);
			output.delete();
		}catch (FileNotFoundException e){
			fail("Did not create expected PD file.");
		}
		
	}
	
	//Invalid SDDs will be allowed
	public void testWriteSDDs_InvalidPDFile() throws XMLValidationException, FileNotFoundException, IOException{
		
		Collection<Document> sdds = new ArrayList<Document>();
		sdds.add(getSDDData(AllTests.INVALID_PDFILE));
		btgApp.writeDescriptorsToFiles(sdds, fileNameBase);
		
		File output = new File(fileNameBase+".pd.xml");
		
		try {
			FileInputStream f = new FileInputStream(output);
			output.delete();
		}catch (FileNotFoundException e){
			fail("Did not create expected PD file.");
		}
		/*try {
			btgApp.writeDescriptorsToFiles(sdds, fileNameBase);
			fail("Invalid DD file, but no XMLValidationException was thrown");
		}catch (XMLValidationException e){
			//Expect to get this.
		}*/
		
	}
	
	
	public void testWriteSDDs_FileNotFound() throws IOException, XMLValidationException{
		try {
			Collection<Document> sdds = new ArrayList<Document>();
			sdds.add(getSDDData("aFile.xml"));
			
			btgApp.writeDescriptorsToFiles(sdds, fileNameBase);
			File output = new File(fileNameBase+".pd.xml");
			
			fail("Invalid file name, but no FileNotFoundException was thrown");
		}catch (FileNotFoundException e){
			//Expect to get this.
		}
	}
		
	public void testNullDescriptorList() throws FileNotFoundException, XMLValidationException, IOException{
		try {
			btgApp.writeDescriptorsToFiles(null, fileNameBase);
			assertTrue(true);
		}catch (NullPointerException e){
			fail("Null descriptor list not handled.");
		}
	}
	
	public void testNullItemInDescriptorList() throws FileNotFoundException, XMLValidationException, IOException{
		Collection<Document> sdds = new ArrayList<Document>();
		sdds.add(getSDDData(AllTests.VALID_PDFILE));
		sdds.add(null);
		
		btgApp.writeDescriptorsToFiles(sdds, fileNameBase);
		
		File output = new File(fileNameBase+".pd.xml");
		
		try {
			btgApp.writeDescriptorsToFiles(sdds, fileNameBase);
			assertTrue(true);
		}catch (NullPointerException e){
			fail("Null item in descriptor list not handled.");
		}
	}
	
	
	
}
