/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
/**
 * 
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.sdd;

import java.io.FileNotFoundException;
import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.sdd.SDDReader;
import org.xml.sax.SAXException;

/**
 * 
 *
 */
public class SDDReader_Test extends TestCase {

	/**
	 * @param name
	 */
	public SDDReader_Test(String name) {
		super(name);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	public void testValidFileName() throws IOException {
		String filename = AllTests.VALID_DD;
		SDDReader reader = new SDDReader(filename);
	}
	
	public void testInvalidFileName() throws IOException, ParserConfigurationException, SAXException {
		String filename = "C:\\badfilename.xml";
		try {
			SDDReader reader = new SDDReader(filename);
			reader.getSDDData();
			fail("Did not throw FileNotFoundException when invalid file name is given.");
		} catch (FileNotFoundException e) {
			// Expected
		}
	}
	
	public void testInvalidFile_NotXML() throws IOException {
		String filename = AllTests.NOT_XML;
		try {
			
			SDDReader reader = new SDDReader(filename);
			reader.getSDDData();
			fail("Did not throw Exception when non-xml file is given.");
		} catch (Exception e) {
			// Expected
		}
	}
}
