/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.stat.datamgr.client;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.IStatisticalClient;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalObservation;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalTuple;
import org.eclipse.cosmos.dc.internal.stat.datamgr.common.DataSourceKeyset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalDataManagerClient
implements IStatisticalClient {
    private EndpointReference epr;
    private ServiceClient sender;
    public static final String DM_NAMESPACE = "http://datamgr.stat.internal.dc.cosmos.eclipse.org";

    public StatisticalDataManagerClient(String eprstr) throws CosmosException {
        this.epr = new EndpointReference(eprstr);
        this.Init();
    }

    @Override
    public Collection<DataSourceKeyset> getDatasourceKeyset() throws CosmosException {
        Collection<DataSourceKeyset> ret = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getDatasourceKeysets", omNs);
        OMElement result = null;
        try {
            result = this.sender.sendReceive(tsRequest);
        }
        catch (AxisFault a) {
            throw new CosmosException((Throwable)a);
        }
        Iterator Iter = result.getChildElements();
        ret = this.processGDK(Iter);
        return ret;
    }

    @Override
    public Collection<StatisticalTuple> getStatDataForSource(String dataset, String keyset, int start, int size) throws CosmosException {
        Collection<StatisticalTuple> ret = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getStatDataForSources", omNs);
        OMElement value1 = fac.createOMElement("dataset", omNs);
        value1.addChild((OMNode)fac.createOMText((OMContainer)value1, dataset));
        tsRequest.addChild((OMNode)value1);
        value1 = fac.createOMElement("keyset", omNs);
        value1.addChild((OMNode)fac.createOMText((OMContainer)value1, keyset));
        tsRequest.addChild((OMNode)value1);
        value1 = fac.createOMElement("start", omNs);
        value1.addChild((OMNode)fac.createOMText((OMContainer)value1, String.valueOf(start)));
        tsRequest.addChild((OMNode)value1);
        value1 = fac.createOMElement("size", omNs);
        value1.addChild((OMNode)fac.createOMText((OMContainer)value1, String.valueOf(size)));
        tsRequest.addChild((OMNode)value1);
        OMElement result = null;
        try {
            result = this.sender.sendReceive(tsRequest);
        }
        catch (AxisFault axisFault) {
            throw new CosmosException("AxisFault");
        }
        Iterator Iter = result.getChildElements();
        ret = this.processSDFS(Iter);
        return ret;
    }

    private void Init() throws CosmosException {
        Options options = new Options();
        options.setTo(this.epr);
        options.setTransportInProtocol("http");
        try {
            this.sender = new ServiceClient();
        }
        catch (AxisFault axisFault) {
            throw new CosmosException("AxisFault");
        }
        this.sender.setOptions(options);
    }

    private Collection<DataSourceKeyset> processGDK(Iterator Iter) {
        ArrayList<DataSourceKeyset> ret = new ArrayList<DataSourceKeyset>();
        this.PopulateGDK(Iter, ret);
        return ret;
    }

    private Collection<StatisticalTuple> processSDFS(Iterator Iter) throws CosmosException {
        ArrayList<StatisticalTuple> ret = new ArrayList<StatisticalTuple>();
        this.PopulateSDFS(Iter, ret);
        return ret;
    }

    private void PopulateSDFS(Iterator Iter, ArrayList<StatisticalTuple> list) throws CosmosException {
        StatisticalTuple tmp = null;
        while (Iter.hasNext()) {
            Iterator n;
            StatisticalObservation s;
            String t;
            OMElement elem = (OMElement)Iter.next();
            if (elem.getLocalName().equals("CAPTURE_TIME")) {
                tmp = new StatisticalTuple();
                t = elem.getText();
                Date d = null;
                try {
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
                    d = sd.parse(t);
                }
                catch (Exception exception) {
                    throw new CosmosException("Couldn't parse date " + t);
                }
                tmp.setTimeStamp(d);
                list.add(tmp);
            }
            if (elem.getLocalName().equals("STRING_VALUE")) {
                t = elem.getText();
                StatisticalObservation s2 = new StatisticalObservation("string", t);
                tmp.add(s2);
            }
            if (elem.getLocalName().equals("INTEGRAL_VALUE")) {
                t = elem.getText();
                Integer I = new Integer(Integer.valueOf(t));
                s = new StatisticalObservation("integer", I);
                tmp.add(s);
            }
            if (elem.getLocalName().equals("DECIMAL_VALUE")) {
                t = elem.getText();
                Double db = new Double(Double.valueOf(t));
                s = new StatisticalObservation("double", db);
                tmp.add(s);
            }
            if ((n = elem.getChildElements()) == null) continue;
            this.PopulateSDFS(n, list);
        }
    }

    private void PopulateGDK(Iterator Iter, ArrayList<DataSourceKeyset> list) {
        DataSourceKeyset tmp = null;
        String d = null;
        String k = null;
        while (Iter.hasNext()) {
            Iterator n;
            String t;
            OMElement elem = (OMElement)Iter.next();
            if (elem.getLocalName().equals("Dataset") && (t = elem.getText()) != null && t.length() > 0) {
                d = new String(t);
            }
            if (elem.getLocalName().equals("Keyset")) {
                t = elem.getText();
                if (t != null && t.length() > 0) {
                    k = new String(t);
                }
                if (d != null) {
                    tmp = new DataSourceKeyset(d, k);
                    list.add(tmp);
                    d = null;
                }
            }
            if ((n = elem.getChildElements()) == null) continue;
            this.PopulateGDK(n, list);
        }
    }
}

