/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.PropertyType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipConstraintType {
    public static Collection<RelationshipConstraint> merge(Collection<RelationshipConstraint> relationshipConstraints1, Collection<RelationshipConstraint> relationshipConstraints2) {
        ArrayList<RelationshipConstraint> relationshipConstraintsToRemove = new ArrayList<RelationshipConstraint>();
        for (RelationshipConstraint relationshipConstraint1 : relationshipConstraints1) {
            for (RelationshipConstraint relationshipConstraint2 : relationshipConstraints2) {
                if (relationshipConstraintsToRemove.contains(relationshipConstraint2) || !RelationshipConstraintType.equals(relationshipConstraint1, relationshipConstraint2)) continue;
                relationshipConstraintsToRemove.add(relationshipConstraint2);
                relationshipConstraint1 = RelationshipConstraintType.merge(relationshipConstraint1, relationshipConstraint2);
            }
        }
        relationshipConstraints2.removeAll(relationshipConstraintsToRemove);
        ArrayList<RelationshipConstraint> finalRelationshipConstraints = new ArrayList<RelationshipConstraint>();
        finalRelationshipConstraints.addAll(relationshipConstraints1);
        finalRelationshipConstraints.addAll(relationshipConstraints2);
        return finalRelationshipConstraints;
    }

    public static RelationshipConstraint merge(RelationshipConstraint relationshipConstraint1, RelationshipConstraint relationshipConstraint2) {
        relationshipConstraint1.setDescription(TranslatableStringType.merge(relationshipConstraint1.getDescription(), relationshipConstraint2.getDescription()));
        relationshipConstraint1.setShortDescription(TranslatableStringType.merge(relationshipConstraint1.getShortDescription(), relationshipConstraint2.getShortDescription()));
        return relationshipConstraint1;
    }

    public static boolean equals(RelationshipConstraint constraint1, RelationshipConstraint constraint2) {
        if (constraint1.getRelatedResourceReference() != null && constraint2.getRelatedResourceReference() == null) {
            return false;
        }
        if (constraint2.getRelatedResourceReference() != null && constraint1.getRelatedResourceReference() == null) {
            return false;
        }
        return constraint2.getRelatedResourceReference() != null && constraint1.getRelatedResourceReference() != null && ResourceType.equals(Util.resolveResourceRef(constraint1.getRelatedResourceReference()), Util.resolveResourceRef(constraint2.getRelatedResourceReference())) && StringType.equals(constraint1.getType(), constraint2.getType()) && PropertyType.equals(constraint1.getProperties(), constraint2.getProperties());
    }
}

