/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Translatable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SPIDataObject
extends SPIObject
implements Translatable {
    private Node node = null;
    private String sddSchemaType = null;

    public SPIDataObject(Node element, SPISessionImpl session, String sddSchemaType) {
        super(session);
        this.node = element;
        this.sddSchemaType = sddSchemaType;
    }

    public Element getElement() {
        if (this.node instanceof Element) {
            return (Element)this.node;
        }
        return null;
    }

    public String getAttribute(String name) {
        if (this.node instanceof Element) {
            return this.isSetAttribute(name) ? ((Element)this.node).getAttribute(name) : null;
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        if (this.node instanceof Element) {
            if (value == null || value.length() == 0) {
                ((Element)this.node).removeAttribute(name);
            } else {
                ((Element)this.node).setAttribute(name, value);
            }
        }
    }

    public void unSetElement(String name) {
        this.removeContent(this.getChildren(name, false));
    }

    public void unSetAttribute(String name) {
        this.getElement().removeAttribute(name);
    }

    public Collection<Element> getChildren(String name) {
        return this.getChildren(name, this.session.isUseCopy());
    }

    public Collection<Element> getChildren(String name, boolean copy) {
        Collection<Node> list = this.getNodeList(name);
        ArrayList<Element> collection = new ArrayList<Element>();
        for (Node node : list) {
            if (!(node instanceof Element)) continue;
            if (copy) {
                collection.add((Element)node.cloneNode(true));
                continue;
            }
            collection.add((Element)node);
        }
        return collection;
    }

    public Element getChild(String name) {
        return this.getChild(name, this.session.isUseCopy());
    }

    public Element getChild(String name, boolean copy) {
        Collection<Node> list = this.getNodeList(name);
        Element element = null;
        for (Node node : list) {
            if (!(node instanceof Element)) continue;
            element = (Element)node;
            if (copy) {
                element = (Element)node.cloneNode(true);
                break;
            }
            element = (Element)node;
            break;
        }
        return element;
    }

    private Collection<Node> getNodeList(String nodeName) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = this.node.getChildNodes();
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getLocalName() != null && (node.getLocalName().equals(nodeName) || nodeName.endsWith(":" + node.getLocalName())) || node.getNodeName().equals(nodeName) || node.getNodeName().endsWith(":" + nodeName)) {
                    list.add(node);
                }
                ++i;
            }
        }
        return list;
    }

    public boolean isSetElement(String name) {
        return this.getChild(name) != null;
    }

    public boolean isSetAttribute(String name) {
        Node n;
        NamedNodeMap map;
        String attribute = "";
        if (this.node instanceof Element) {
            attribute = ((Element)this.node).getAttribute(name);
        } else if (this.node instanceof Document && (map = ((Document)this.node).getAttributes()) != null && (n = map.getNamedItem(name)) != null) {
            attribute = n.getTextContent();
        }
        boolean value = attribute.length() > 0;
        return value;
    }

    public void setContent(SPIDataObject spiObject) {
        this.setContent(spiObject, this.session.isUseCopy());
    }

    public void setContent(SPIDataObject spiObject, boolean copy) {
        this.session.testParameter(spiObject, 1, null);
        if (spiObject != null) {
            this.setContent(spiObject.getElement(), copy);
        }
    }

    public void setContent(Element element) {
        this.setContent(element, this.session.isUseCopy());
    }

    public void setContent(Element element, boolean copy) {
        this.session.testParameter(element, 1, null);
        if (element != null) {
            String elementName = element.getLocalName() != null ? element.getLocalName() : element.getNodeName();
            Collection<Element> children = this.getChildren(elementName, false);
            this.removeContent(children);
            if (copy) {
                this.session.insertNode(this.node, element.cloneNode(true), this.sddSchemaType);
            } else {
                this.session.insertNode(this.node, (Node)element, this.sddSchemaType);
            }
        }
    }

    public <T> void addContent(Collection<T> elements) {
        this.addContent(elements, this.session.isUseCopy());
    }

    public <T> void addContent(Collection<T> elements, boolean copy) {
        for (T element : elements) {
            if (element instanceof Element) {
                if (copy) {
                    this.session.insertNode(this.node, ((Element)element).cloneNode(true), this.sddSchemaType);
                    continue;
                }
                this.session.insertNode(this.node, (Node)((Element)element), this.sddSchemaType);
                continue;
            }
            if (!(element instanceof SPIDataObject)) continue;
            if (copy) {
                this.session.insertNode(this.node, ((SPIDataObject)element).getElement().cloneNode(true), this.sddSchemaType);
                continue;
            }
            this.session.insertNode(this.node, (Node)((SPIDataObject)element).getElement(), this.sddSchemaType);
        }
    }

    public <T> void removeContent(Collection<T> elements) {
        for (T element : elements) {
            if (element instanceof Element) {
                this.node.removeChild((Element)element);
                continue;
            }
            if (!(element instanceof SPIDataObject)) continue;
            this.node.removeChild(((SPIDataObject)element).getElement());
        }
    }

    @Override
    public Properties getTranslatableStrings() {
        Properties p = ConversionUtil.dumpStrings(this.node);
        return p;
    }
}

