/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.w3c.dom.Element;

public class LanguageSet_Test
extends TestCase {
    LanguageSet lang;
    LanguageSet clonedLang;
    Element element;
    SPISessionImpl session;

    public LanguageSet_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Language lang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang1");
        Language lang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang2");
        this.lang = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguageSet((Collection<Language>)Arrays.asList(lang1, lang2));
        this.lang.setDisplayName(new TranslatableString("displayName", "displayNameKey"));
        this.lang.setDescription(new TranslatableString("desc", "descKey"));
        this.lang.setShortDescription(new TranslatableString("shortDesc", "shortDescKey"));
        this.clonedLang = (LanguageSet)this.lang.clone();
        this.element = ((SPIDataObject)((Object)this.lang)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = this.lang.getTranslatableStrings();
        Properties clonedProps = this.clonedLang.getTranslatableStrings();
        LanguageSet_Test.assertEquals((int)3, (int)props.keySet().size());
        LanguageSet_Test.assertEquals((int)3, (int)clonedProps.keySet().size());
        LanguageSet_Test.assertEquals((Object)"desc", (Object)props.get("descKey"));
        LanguageSet_Test.assertEquals((Object)"shortDesc", (Object)props.get("shortDescKey"));
        LanguageSet_Test.assertEquals((Object)"displayName", (Object)props.get("displayNameKey"));
        LanguageSet_Test.assertEquals((Object)"desc", (Object)clonedProps.get("descKey"));
        LanguageSet_Test.assertEquals((Object)"shortDesc", (Object)clonedProps.get("shortDescKey"));
        LanguageSet_Test.assertEquals((Object)"displayName", (Object)clonedProps.get("displayNameKey"));
    }

    public void testGetLanguages() {
        LanguageSet_Test.assertEquals((int)2, (int)this.lang.getLanguages().size());
        LanguageSet_Test.assertEquals((int)2, (int)this.clonedLang.getLanguages().size());
        LanguageSet_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "Language").size());
        LanguageSet_Test.assertEquals((String)"lang1", (String)this.lang.getLanguages().toArray(new Language[0])[0].getType());
        LanguageSet_Test.assertEquals((String)"lang2", (String)this.lang.getLanguages().toArray(new Language[0])[1].getType());
        LanguageSet_Test.assertEquals((String)"lang1", (String)this.clonedLang.getLanguages().toArray(new Language[0])[0].getType());
        LanguageSet_Test.assertEquals((String)"lang2", (String)this.clonedLang.getLanguages().toArray(new Language[0])[1].getType());
        LanguageSet_Test.assertEquals((String)"lang1", (String)this.session.getChildren(this.element, "Language").toArray(new Element[0])[0].getAttribute("type"));
        LanguageSet_Test.assertEquals((String)"lang2", (String)this.session.getChildren(this.element, "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetDisplayName() {
        LanguageSet_Test.assertEquals((String)"displayName", (String)this.lang.getDisplayName().getValue());
        LanguageSet_Test.assertEquals((String)"displayNameKey", (String)this.lang.getDisplayName().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"displayName", (String)this.clonedLang.getDisplayName().getValue());
        LanguageSet_Test.assertEquals((String)"displayNameKey", (String)this.clonedLang.getDisplayName().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"displayName", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getTextContent());
        LanguageSet_Test.assertEquals((String)"displayNameKey", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDescription() {
        LanguageSet_Test.assertEquals((String)"desc", (String)this.lang.getDescription().getValue());
        LanguageSet_Test.assertEquals((String)"descKey", (String)this.lang.getDescription().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"desc", (String)this.clonedLang.getDescription().getValue());
        LanguageSet_Test.assertEquals((String)"descKey", (String)this.clonedLang.getDescription().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"desc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        LanguageSet_Test.assertEquals((String)"descKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        LanguageSet_Test.assertEquals((String)"shortDesc", (String)this.lang.getShortDescription().getValue());
        LanguageSet_Test.assertEquals((String)"shortDescKey", (String)this.lang.getShortDescription().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"shortDesc", (String)this.clonedLang.getShortDescription().getValue());
        LanguageSet_Test.assertEquals((String)"shortDescKey", (String)this.clonedLang.getShortDescription().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"shortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        LanguageSet_Test.assertEquals((String)"shortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetLanguages() {
        Language lang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang3");
        this.lang.setLanguages((Collection<Language>)Arrays.asList(lang1));
        LanguageSet_Test.assertEquals((int)1, (int)this.lang.getLanguages().size());
        LanguageSet_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "Language").size());
        LanguageSet_Test.assertEquals((String)"lang3", (String)this.lang.getLanguages().toArray(new Language[0])[0].getType());
        LanguageSet_Test.assertEquals((String)"lang3", (String)this.session.getChildren(this.element, "Language").toArray(new Element[0])[0].getAttribute("type"));
        try {
            this.lang.setLanguages(null);
            LanguageSet_Test.fail((String)"Languages set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetDisplayName() {
        this.lang.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        LanguageSet_Test.assertEquals((String)"differentName", (String)this.lang.getDisplayName().getValue());
        LanguageSet_Test.assertEquals((String)"differentNameKey", (String)this.lang.getDisplayName().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getTextContent());
        LanguageSet_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetDescription() {
        this.lang.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        LanguageSet_Test.assertEquals((String)"differentDesc", (String)this.lang.getDescription().getValue());
        LanguageSet_Test.assertEquals((String)"differentDescKey", (String)this.lang.getDescription().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"differentDesc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        LanguageSet_Test.assertEquals((String)"differentDescKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.lang.setShortDescription(new TranslatableString("differentShortDesc", "differentShortDescKey"));
        LanguageSet_Test.assertEquals((String)"differentShortDesc", (String)this.lang.getShortDescription().getValue());
        LanguageSet_Test.assertEquals((String)"differentShortDescKey", (String)this.lang.getShortDescription().getTranslationKey());
        LanguageSet_Test.assertEquals((String)"differentShortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        LanguageSet_Test.assertEquals((String)"differentShortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }
}

