/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;
import org.w3c.dom.Element;

// Still need to override setName, to prevent setting to null.
public class PackageIdentityImpl extends IdentityImpl implements PackageIdentity {
	private static final String PACKAGE_IDENTITY_TYPE = "sdd-pd:PackageIdentityType";
    
	public PackageIdentityImpl(Element data, SPISessionImpl session) {
        super(data, session, PACKAGE_IDENTITY_TYPE);
    }
    
    public Collection<String> getPackageTypes() {
    	String packageTypesList = getAttribute("packageType");
    	
    	Collection<String> packageTypes = new ArrayList<String>();
    	
    	if (packageTypesList != null && packageTypesList.length() > 0) {
    		String[] tokens = packageTypesList.split(" ");
    		
    		for (String token : tokens) {
    			packageTypes.add(token);
    		}
    	}

        return packageTypes;
    }
    
    public String getContentType() {
		return getAttribute("contentType");
    }

    public String getLabel() {
    	return getAttribute("label");
    }

    public void setContentType(String contentType) {
   		setAttribute("contentType", contentType);
    }

    public void setLabel(String label) {
   		setAttribute("label", label);
    }

    public void setPackageTypes(Collection<String> packageTypes) {
        // TODO check for enum value match
        if (packageTypes == null || packageTypes.size() == 0) {
            unSetAttribute("packageType");
        }
        else {
        	String packageTypeString = "";
        	
        	for (String packageType : packageTypes) {
        		packageTypeString += packageType + " ";
        	}
        	packageTypeString = packageTypeString.substring(0, packageTypeString.length() - 1);
        	
        	setAttribute("packageType", packageTypeString);
        }    	
    }
    
    public Object clone() {
    	return new PackageIdentityImpl((Element)getElement().cloneNode(true), session);
    }

    public String toString(){
        String packageIdentityContents = 
            "Package Types: " + getPackageTypes() + "\n";
        
        if (isSetAttribute("contentType")) {
            packageIdentityContents += "Content Type: " + getContentType() + "\n";
        }

        if (isSetAttribute("label")) {
            packageIdentityContents += "Label: " + getLabel() + "\n";
        }
        
        return packageIdentityContents + super.toString(); 
    }
}
