/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.AlternativeCondition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalPropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.w3c.dom.Element;

public class ConditionFactoryImpl implements ConditionFactory {
	private SPISessionImpl session;
	private static final String PROPERTY_VALUE_LIST_TYPE = "sdd-dd:PropertyValueListType";
	private static final String CONDITIONAL_PROPERTY_CONSTRAINT_TYPE = "sdd-dd:ConditionalPropertyConstraintType";
	private static final String VERSION_VALUE_TYPE = "sdd-dd:VersionValueType"; 
	
	public ConditionFactoryImpl(SPISessionImpl session) {
		this.session = session;
	}

	public AlternativeCondition createAlternativeCondition(String alternativeConditionID) {
		session.testParameter(alternativeConditionID, 1, null);

		Element alternativeConditionElement = session.createDeploymentElement("Alternative");
		alternativeConditionElement.setAttribute("id", alternativeConditionID);
		
		return new AlternativeConditionImpl(alternativeConditionElement, session);
	}

	public Condition createCondition()	{
		Element conditionElement = session.createDeploymentElement("Condition");
		return new ConditionImpl(conditionElement, session);
	}

	public ConditionalPropertyConstraint createConditionalPropertyConstraintMultiValue(
			String propertyName, Collection<String> propertyValues) {
		session.testParameter(propertyName, 1, null);
		session.testParameter(propertyValues, 2, null);
		
		Element propertyValueListElement = session.createDeploymentElement("ListOfValues");
		
		for (String propertyValue : propertyValues) {
			Element valueElement = session.createDeploymentElement("Value");
			valueElement.setTextContent(propertyValue);
			
			session.insertNode(propertyValueListElement, valueElement, PROPERTY_VALUE_LIST_TYPE);
		}
			
		Element propertyNameElement = session.createDeploymentElement("PropertyName");
		propertyNameElement.setTextContent(propertyName);
		
		Element cpcElement = session.createDeploymentElement("PropertyConstraint");
		session.insertNode(cpcElement, propertyNameElement, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
		session.insertNode(cpcElement, propertyValueListElement, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
		
		return new ConditionalPropertyConstraintImpl(cpcElement, session);
	}

	public ConditionalPropertyConstraint createConditionalPropertyConstraintSingleValue(
			String propertyName, String value) {
		session.testParameter(propertyName, 1, null);
		session.testParameter(value, 2, null);
		
		Element propertyNameElement = session.createDeploymentElement("PropertyName");
		propertyNameElement.setTextContent(propertyName);
		
		Element valueElement = session.createDeploymentElement("Value");
		valueElement.setTextContent(value);
		
		Element cpcElement = session.createDeploymentElement("PropertyConstraint");
        session.insertNode(cpcElement, propertyNameElement, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
        session.insertNode(cpcElement, valueElement, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
		
		return new ConditionalPropertyConstraintImpl(cpcElement, session);
	}

	public ConditionalResourceConstraint createConditionalResourceConstraint(String constraintID, 
			String resourceReference) {
	    session.testParameter(constraintID, 1, null);
		session.testParameter(resourceReference, 2, null);

		Element crcElement = session.createDeploymentElement("ResourceConstraint");
		crcElement.setAttribute("resourceRef", resourceReference);
		crcElement.setAttribute("id", constraintID);
		
		return new ConditionalResourceConstraintImpl(crcElement, session);
	}

	public VersionRange createVersionRange() {
		Element versionRangeElement = session.createDeploymentElement("Range");
		
		return new VersionRangeImpl(versionRangeElement, session);
	}

	public VersionValue createVersionValue(String version) {
		session.testParameter(version, 1, null);
		
		Element versionElement = session.createDeploymentElement("Version");
		versionElement.setTextContent(version);

		Element versionValueElement = session.createDeploymentElement("Value");
		session.insertNode(versionValueElement, versionElement, VERSION_VALUE_TYPE);
		
		return new VersionValueImpl(versionValueElement, session);
	}
}