/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RelationshipConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.UniquenessConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.VersionConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalPropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.UniquenessConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;
import org.w3c.dom.Element;

public class ConditionalResourceConstraintImpl extends DisplayNameableObject implements ConditionalResourceConstraint {
	private static final String CONDITIONAL_RESOURCE_CONSTRAINT_TYPE = "sdd-dd:ConditionalResourceConstraintType";
	
	public ConditionalResourceConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, CONDITIONAL_RESOURCE_CONSTRAINT_TYPE);		
	}

    public String getName() {
		String value = null;
		
		if (isSetElement("Name")) {
			value =  getChild("Name").getTextContent();
		}
				
		return value;
    }
	
    public String getConstraintID() {
    	return getAttribute("id");
    }

    public String getResourceReference() {
    	return getAttribute("resourceRef");
	}

	public Boolean getTestValue() {
		String value = getAttribute("testValue");
		
		if (value != null) {
			return Boolean.parseBoolean(value);
		}
		else {
			return null;
		}
	}

	public Collection<VersionRange> getVersionRanges() {
		Collection<VersionRange> versionRanges = new ArrayList<VersionRange>();
		
		if (isSetElement("VersionConstraint")) {
			VersionConstraint versionConstraint = new VersionConstraintImpl(getChild("VersionConstraint"), session);
			versionRanges.addAll(versionConstraint.getVersionRanges());
		}
		
		return versionRanges;
	}

	public Collection<VersionValue> getVersionValues() {
		Collection<VersionValue> versionValues = new ArrayList<VersionValue>();
		
		if (isSetElement("VersionConstraint")) {
			VersionConstraint versionConstraint = new VersionConstraintImpl(getChild("VersionConstraint"), session);
			versionValues.addAll(versionConstraint.getVersionValues());
		}
		
		return versionValues;
	}

	public Collection<ConditionalPropertyConstraint> getConditionalMultiValuePropertyConstraints() {
		Collection<ConditionalPropertyConstraint> multiValueConstraints = 
			new ArrayList<ConditionalPropertyConstraint>();
		
		if (isSetElement("PropertyConstraint")) {
			Collection<Element> constraintElements = getChildren("PropertyConstraint");
			
			for (Element constraint : constraintElements) 
			{
				if (!session.getChildren(constraint, "ListOfValues").isEmpty()) 
				{
					multiValueConstraints.add(new ConditionalPropertyConstraintImpl(constraint, session));
				}
			}		
		}
		
		return multiValueConstraints;
	}

	public Collection<ConditionalPropertyConstraint> getConditionalSingleValuePropertyConstraints() {
		Collection<ConditionalPropertyConstraint> singleValueConstraints = 
			new ArrayList<ConditionalPropertyConstraint>();
		
		if (isSetElement("PropertyConstraint")) {
			Collection<Element> constraintElements = getChildren("PropertyConstraint");
			
			for (Element constraint : constraintElements) {
				if (!session.getChildren(constraint, "Value").isEmpty()) {
					singleValueConstraints.add(new ConditionalPropertyConstraintImpl(constraint, session));
				}
			}
		}
		
		return singleValueConstraints;
	}
	
    public void setName(String name) {
    	if (name != null) {
			Element nameElement = session.createDeploymentElement("Name");
			nameElement.setTextContent(name);
			setContent(nameElement);
		}
    	else {
    		unSetElement("Name");
    	}
    }

    public void setConstraintID(String id) {
        session.testParameter(id, 1, null);
        
        setAttribute("id", id);
    }

    public void setResourceReference(String resourceReference) {
		session.testParameter(resourceReference, 1, null);
		setAttribute("resourceRef", resourceReference);
	}
	
	public void setTestValue(Boolean testValue) {
		if (testValue != null) {
			setAttribute("testValue", testValue.toString());
		}
		else {
			unSetAttribute("testValue");
		}
	}

	public void setVersionRanges(Collection<VersionRange> newVersionRanges) {
		if (!isSetElement("VersionConstraint")) {
			Element versionConstraintElement = session.createDeploymentElement("VersionConstraint");
			setContent(versionConstraintElement);
		}
		
		VersionConstraint versionConstraint = new VersionConstraintImpl(getChild("VersionConstraint"), session);		
		versionConstraint.setVersionRanges(newVersionRanges);
		
		setContent((SPIDataObject)versionConstraint);
	}

	public void setVersionValues(Collection<VersionValue> newVersionValues) {
		if (!isSetElement("VersionConstraint")) {
			Element versionConstraintElement = session.createDeploymentElement("VersionConsrtaint");
			setContent(versionConstraintElement);
		}
		
		VersionConstraint versionConstraint = new VersionConstraintImpl(getChild("VersionConstraint"), session);		
		versionConstraint.setVersionValues(newVersionValues);
		
		setContent((SPIDataObject)versionConstraint);
	}
	
	public void setConditionalMultiValuePropertyConstraints(
			Collection<ConditionalPropertyConstraint> propertyConstraints) {
		
		if (isSetElement("PropertyConstraint")) {
			Collection<Element> constraintElements = getChildren("PropertyConstraint", false);
			Collection<Element> multiValueElements = new ArrayList<Element>();
		
			for (Element constraint : constraintElements) {
				if (!session.getChildren(constraint, "ListOfValues").isEmpty()) {
					multiValueElements.add(constraint);
				}			
			}
		
			removeContent(multiValueElements);
		}
		
		addContent(propertyConstraints);
	}

	public void setConditionalSingleValuePropertyConstraints(
			Collection<ConditionalPropertyConstraint> propertyConstraints) { 
		
		if (isSetElement("PropertyConstraint")) {
			Collection<Element> constraintElements = getChildren("PropertyConstraint", false);
			Collection<Element> singleValueElements = new ArrayList<Element>();
		
			for (Element constraint : constraintElements) {
				if (!session.getChildren(constraint, "Value").isEmpty()) {
					singleValueElements.add(constraint);
				}			
			}
		
			removeContent(singleValueElements);
		}
		
		addContent(propertyConstraints);
	}

	public Object clone() {
		return new ConditionalResourceConstraintImpl((Element)getElement().cloneNode(true), session);
	}
	
    public Collection<RelationshipConstraint> getRelationshipConstraints() {
    	Collection<RelationshipConstraint> relationshipConstraints = new ArrayList<RelationshipConstraint>();
    	
    	if (isSetElement("RelationshipConstraint")) {
    		Collection<Element> relationshipElements = getChildren("RelationshipConstraint");
    		
    		for (Element constraint : relationshipElements) {
    			relationshipConstraints.add(new RelationshipConstraintImpl(constraint, session));
    		}
    	}
        
        return relationshipConstraints;
    }

    public Collection<UniquenessConstraint> getUniquenessConstraints() {
    	Collection<UniquenessConstraint> uniquenessConstraints = new ArrayList<UniquenessConstraint>();
    	
    	if (isSetElement("UniquenessConstraint")) {
    		Collection<Element> uniquenessElements = getChildren("UniquenessConstraint");
    		
    		for (Element constraint : uniquenessElements) {
    			uniquenessConstraints.add(new UniquenessConstraintImpl(constraint, session));
    		}
    	}
        
        return uniquenessConstraints;
    }

    public void setRelationshipConstraints(Collection<RelationshipConstraint> relationshipConstraints) {
		removeContent(getChildren("RelationshipConstraint", false));
				
		addContent(relationshipConstraints);
    }

    public void setUniquenessConstraints(Collection<UniquenessConstraint> uniquenessConstraints) {
		removeContent(getChildren("UniquenessConstraint", false));
		
		addContent(uniquenessConstraints);
    }
}
