/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.URIParameter;
import org.w3c.dom.Element;

public class URIParameterImpl extends ParameterImpl implements URIParameter {
	private static final String URI_PARAMETER_TYPE = "sdd-dd:URIParameterType";
	
	public URIParameterImpl(Element data, SPISessionImpl session) {
		super(data, session, URI_PARAMETER_TYPE);
	}
	
	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		URIParameterImpl duplicate = new URIParameterImpl(copy, session);
		
		return duplicate;
	}
}