/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.sdd;

import java.util.Collection;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.sdd.SDDReader;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataCollector;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;


public class SDDDataCollector implements IBTGDataCollector {
	private static Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg");//$NON-NLS-1$
    private static Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg.stdout");//$NON-NLS-1$

	public Collection<SDDFragment> collectSDDData(Properties properties) throws Exception {
		Collection<SDDFragment> sddFragments = new Vector<SDDFragment>();
		
		SDDReader sddReader = new SDDReader(properties.getProperty("FileName")); //$NON-NLS-1$
		sddFragments.add(new SDDFragment(sddReader.getSDDData(), properties));

		return sddFragments;
	}
	
	public Collection<BTGProperty> getSupportedProperties() {
		Collection <BTGProperty> properties = new Vector<BTGProperty>();
		
		// FileName
		properties.add(new BTGProperty("FileName", true)); //$NON-NLS-1$
		
		return properties;
	}
}