/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Multiplicity;



public class MultiplicityType {
	
	/*
	 * <xsd:complexType name="MultiplicityType">
		  <xsd:sequence>
		    <xsd:element name="ConstrainedFeature" type="sdd-dd:FeatureReferenceType" minOccurs="0" maxOccurs="unbounded"/>
		    <xsd:element name="ConstrainedResource" type="sdd-dd:ConstrainedResourceType" minOccurs="0" maxOccurs="unbounded"/>
		    <xsd:any namespace="##other" processContents="lax" minOccurs="0" maxOccurs="unbounded"/>
		  </xsd:sequence>
		  <xsd:attribute name="multiplesAllowed" type="xsd:boolean" fixed="true" use="required"/>
		  <xsd:attribute name="minSelections" type="xsd:positiveInteger" default="1" use="optional"/>
		  <xsd:attribute name="maxSelections" type="xsd:positiveInteger" use="optional"/>
		  <xsd:anyAttribute namespace="##other" processContents="lax"/>
		</xsd:complexType>

	Type 	Element 	Attribute 	Data Type 	Compare?
		<MultiplicityType> 				
		multiplesAllowed 	xsd:boolean 	Merge
		minSelections 	xsd:positiveInteger 	Merge
		maxSelections 	xsd:positiveInteger 	Merge
		any 	namespace="##other" 	 ?
	ConstrainedFeature 		<FeatureReferenceType> 	Yes
	ConstrainedResource 		<ConstrainedResourceType> 	Yes
	any 		namespace="##other" 	 ?

	Notes:
	If minSelections and maxSelections are different in the two inputs, keep the lowest min and lowest max. If that makes the max smaller than the min, set them both to the smaller of the values and log a warning. 
	 */
	
	public static Multiplicity merge(Multiplicity m1, Multiplicity m2)
	{
		if ((!m1.getMultiplesAllowed())||(!m2.getMultiplesAllowed()))
			m1.setMultiplesAllowed(false);
		if (m1.getMaxSelections().compareTo(m2.getMaxSelections())>0)
			m1.setMaxSelections(m2.getMaxSelections());
		if (m1.getMinSelections().compareTo(m2.getMinSelections())>0)
			m1.setMinSelections(m2.getMinSelections());
		if (m1.getMinSelections().compareTo(m1.getMaxSelections())>0)
			m1.setMaxSelections(m1.getMinSelections());
		
		return m1;
	}
	
	public static boolean equals(Multiplicity m1, Multiplicity m2)
	{
		//compare constrainedfeatures and resources if they exist
		
		Set<String> features1  = new HashSet<String>(m1.getConstrainedFeatures());
		Set<String> features2  = new HashSet<String>(m2.getConstrainedFeatures());
		
		// AbstractSet.equals() does a element by element compare, exactly
		// what we need here
		
		if (features1.equals(features2))
			if (ConstrainedResourceType.equals(m1.getConstrainedResources(), m2.getConstrainedResources()))
				return true;
		return false;
	}
	
}
