/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementNode;

public class ElementTypeMap {
    private Map<String, Map<String, String>> types = new Hashtable<String, Map<String, String>>();

    public void addElementDeclaration(String uri, String name, String type) {
        ElementNode node = new ElementNode();
        node.setUri(uri);
        node.setName(name);
        node.setType(type);
        this.addElementDeclaration(node);
    }

    public void addElementDeclaration(ElementNode elementNode) {
        String type;
        String name;
        String uri = elementNode.getUri();
        if (uri == null || (name = elementNode.getName()) == null || (type = elementNode.getType()) == null) {
            return;
        }
        Map<String, String> elementTypes = this.types.get(uri);
        if (elementTypes == null) {
            elementTypes = new Hashtable<String, String>();
            this.types.put(uri, elementTypes);
        }
        elementTypes.put(name, type);
    }

    public String getType(ElementNode elementNode) {
        return this.getType(elementNode.getUri(), elementNode.getName());
    }

    public String getType(String uri, String name) {
        if (uri == null) {
            return null;
        }
        Map<String, String> elementTypes = this.types.get(uri);
        return elementTypes == null ? null : elementTypes.get(name);
    }
}

