/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl;

import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfMessages;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IItemConstraintHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.osgi.util.NLS;

/**
 * An abstract implementation of IItemConstraintHandler.
 * Adopters can extend this class or provide a direct implementation
 * of {@link IItemConstraintHandler}
 * 
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractItemConstraintHandler extends AbstractQueryHandler implements IItemConstraintHandler
{
	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IItemConstraintHandler#execute(org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IGraphElementCollection, org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IConstraint)
	 */
	public INodes execute(INodes context, IConstraint constraint) throws CMDBfServiceException
	{
		if (!isInitialized())
		{
			throw new CMDBfServiceException (
					CMDBfServiceException.RECIEVER, 
					CMDBfServiceException.QUERY_ERROR,
					CMDBfMessages.faultsQueryError,
					CMDBfInternalUtility.createTextNode(NLS.bind(CMDBfMessages.faultsCommonUninitialized, this.getClass().getName())));
		}
		
		return handle(context, constraint);
	}

	/**
	 * Handler this constraint
	 * 
	 * @param context The context
	 * @param constraint The constraint
	 * @return The result of handling this constraint
	 */
	protected abstract INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException;
	
}
