/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.AdditionalContentType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ContentType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactType {
    public static Collection<Artifact> merge(Collection<Artifact> artifacts1, Collection<Artifact> artifacts2) {
        ArrayList<Artifact> artifactsToRemove = new ArrayList<Artifact>();
        for (Artifact artifact1 : artifacts1) {
            for (Artifact artifact2 : artifacts2) {
                if (artifactsToRemove.contains(artifact2) || !ArtifactType.equals(artifact1, artifact2)) continue;
                artifactsToRemove.add(artifact2);
                artifact1 = ArtifactType.merge(artifact1, artifact2);
            }
        }
        artifacts2.removeAll(artifactsToRemove);
        ArrayList<Artifact> finalArtifacts = new ArrayList<Artifact>();
        finalArtifacts.addAll(artifacts1);
        finalArtifacts.addAll(artifacts2);
        return finalArtifacts;
    }

    public static Artifact merge(Artifact artifact1, Artifact artifact2) {
        artifact1.setPackageType(StringType.merge(artifact1.getPackageType(), artifact2.getPackageType()));
        if (artifact1.getWeight() == null && artifact2.getWeight() != null) {
            artifact1.setWeight(artifact2.getWeight());
        }
        if (artifact1.getWeight() != null && artifact2.getWeight() != null && artifact1.getWeight().compareTo(artifact2.getWeight()) < 0) {
            artifact1.setWeight(artifact2.getWeight());
        }
        artifact1.setAdditionalContents(AdditionalContentType.merge(artifact1.getAdditionalContents(), artifact2.getAdditionalContents()));
        return artifact1;
    }

    public static boolean equals(Artifact artifact1, Artifact artifact2) {
        if (artifact1.getContentReference() != null && artifact2.getContentReference() == null) {
            return false;
        }
        if (artifact2.getContentReference() != null && artifact1.getContentReference() == null) {
            return false;
        }
        if (artifact1.getContentReference() != null && artifact2.getContentReference() != null && !ContentType.equals(Util.resolveContentRef(artifact1.getContentReference()), Util.resolveContentRef(artifact2.getContentReference()))) {
            return false;
        }
        if (artifact1.getResourceReference() != null && artifact2.getResourceReference() == null) {
            return false;
        }
        if (artifact2.getResourceReference() != null && artifact1.getResourceReference() == null) {
            return false;
        }
        return artifact1.getResourceReference() == null || artifact2.getResourceReference() == null || ResourceType.equals(Util.resolveResourceRef(artifact1.getResourceReference()), Util.resolveResourceRef(artifact2.getResourceReference()));
    }
}

