/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BaseVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.BooleanType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.DerivedVariableType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourcePropertyType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseVariableType {
    static <T extends BaseVariable> void merge(Collection<T> newVars, Set<T> mergedVars) {
        Iterator<T> i = newVars.iterator();
        while (i.hasNext()) {
            boolean matches = false;
            BaseVariable newVar = (BaseVariable)i.next();
            for (BaseVariable mergedVar : mergedVars) {
                if (!BaseVariableType.equals(newVar, mergedVar)) continue;
                matches = true;
                BaseVariableType.merge(newVar, mergedVar);
                break;
            }
            if (matches) continue;
            mergedVars.add(newVar);
        }
    }

    static boolean equals(BaseVariable b1, BaseVariable b2) {
        boolean equals = true;
        boolean bl = equals = equals && BooleanType.equals(b1.isSensitive(), b2.isSensitive());
        if (b1 instanceof DerivedVariable) {
            equals = equals && DerivedVariableType.equals((DerivedVariable)b1, (DerivedVariable)b2);
        } else if (b1 instanceof ResourceProperty) {
            equals = equals && ResourcePropertyType.equals((ResourceProperty)b1, (ResourceProperty)b2);
        }
        return equals;
    }

    static BaseVariable merge(BaseVariable newParm, BaseVariable merged) {
        merged.setDescription(TranslatableStringType.merge(newParm.getDescription(), merged.getDescription()));
        merged.setShortDescription(TranslatableStringType.merge(newParm.getShortDescription(), merged.getShortDescription()));
        return merged;
    }
}

